/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.modern;

import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import org.primefaces.model.TreeNode;
import org.rhwlab.encode.ortholog.OrthologService;

/**
 *
 * @author gevirl
 */
public class ViewByTF extends ViewBase implements Serializable  {
    
    
    public void setService(OrthologService service) throws Exception  {
        this.service = service;
        buildTree();
    }
    public void buildTree()throws Exception {

        this.assembly = choosenAssembly();
        this.root = this.service.createTree(species,assembly);  
        peaksUrlsMap.clear();
        addPeaksURLs(root, peaksUrlsMap);   
        addTrackHUBFileURLs(root, trackHubUrlsMap);
    }
    public TreeMap<String, URL> getTrackHubUrls(){
        return this.trackHubUrlsMap;
    }
    
    public TreeNode getRoot() throws Exception {    
        String choosen = choosenAssembly();
        if (!choosen.equals(assembly)){
            buildTree();
        }
        return root;
    }    
    @Override
    public String getZipFileName() {
        return String.format("%sByTF.zip", species);

    }
    TreeMap<String,URL> trackHubUrlsMap = new TreeMap<>();
}
