/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.modern;

import java.io.Serializable;
import org.primefaces.model.TreeNode;
import org.rhwlab.encode.ortholog.OrthologService;

/**
 *
 * @author gevirl
 */
public class ViewByStage extends ViewBase implements Serializable  {
    
    public void setService(OrthologService service) throws Exception {
        this.service = service;
        buildTree();
    }
    
    public void buildTree()throws Exception {

        this.assembly = choosenAssembly();
        this.root = this.service.createByStageTree(species,assembly);  
        peaksUrlsMap.clear();
        addPeaksURLs(root, peaksUrlsMap);        
    }
    
    public TreeNode getRoot() throws Exception {    
        String choosen = choosenAssembly();
        if (!choosen.equals(assembly)){
            buildTree();
        }
        return root;
    }

    
    @Override
    public String getZipFileName() {
        return String.format("%sByStage.zip", species);
    }
}
