/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.modern;

import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import org.primefaces.model.TreeNode;
import org.rhwlab.encode.ortholog.OrthologService;

/**
 *
 * @author gevirl
 */
abstract public class ViewBase implements FileView {
    public TreeNode root;
    public TreeNode[] selectedNodes;
    public OrthologService service;
    public TreeMap<String,URL> urlsMap = new TreeMap<>();
    TreeMap<String,URL> peaksUrlsMap = new TreeMap<>();
    public ReferenceGenome genomes;  // determines which assembly is used in the view
    String assembly;
    public String species;

    public void setGenomes(ReferenceGenome gen){
        this.genomes = gen;
    }
    public void setSpecies(String sp){
        this.species = sp;
    }
    @Override
    public String getSpecies(){
        return species;
    }
    @Override
    public Map<String, URL> getURLs() {
        return urlsMap;
    }
    public Map<String,URL> getURLs(String param)throws Exception {
        TreeMap<String,URL> ret = new TreeMap<>();
        String[] keys = param.split("/");
        RecordBase base = ((RecordBase)root).findRecord(keys, 0);
        if (base != null){
            addURLs(base,ret);
        }
        return ret;
    }
    @Override
    public Map<String, URL> getAllPeaksURLs() {
        return peaksUrlsMap;
    }    
    
    public String choosenAssembly(){
        String ret;
        if (species.equalsIgnoreCase("worm")){
            ret = this.genomes.getWorm();
        }else {
            ret = this.genomes.getFly();
        }   
        return ret;
    }
    

    public TreeNode[] getSelectedNodes() {
        return selectedNodes;
    }
    public void setSelectedNodes(TreeNode[] selectedNodes) throws Exception {
        this.selectedNodes = selectedNodes;
        urlsMap.clear();
        if (selectedNodes == null) return;
        for (TreeNode treeNode : selectedNodes){
            addURLs(treeNode, urlsMap);
        }        
    }
    public void addTrackHUBFileURLs(TreeNode node,Map<String,URL> urls)throws Exception {
        Object data = node.getData();
        if (data instanceof ExperimentalFile) {
            ExperimentalFile subFile = (ExperimentalFile) data;
            String identifier = subFile.getHubIdentifier();
            if (identifier.endsWith("bw")||identifier.endsWith("bb")||identifier.endsWith("Peak.gz")){
                urls.put(identifier, new URL(subFile.getDownloadLink()));
            }
        } else {
            // add all the files from the children
            for (TreeNode child : node.getChildren()) {
                addTrackHUBFileURLs(child, urls);
            }
        }
    }
    public void addPeaksURLs(TreeNode node,Map<String,URL> urls)throws Exception {
        Object data = node.getData();
        if (data instanceof ExperimentalFile){
            ExperimentalFile subFile = (ExperimentalFile)data;
            String id = subFile.getId().toLowerCase();
            
            if (id.contains("optimal")&& id.endsWith(".gz")){
                urls.put(String.format("%s/%s/%s",species,subFile.getAssembly(),subFile.getAccession()+"_"+subFile.getId()), new URL(subFile.getDownloadLink()));
            }
        }
        else {
            // add all the files from the children
            for (TreeNode child : node.getChildren()){
                addPeaksURLs(child,urls);
            }
        }        
    }
    static public void addURLs(TreeNode node,Map<String,URL> urls)throws Exception {
        Object data = node.getData();
        if (data instanceof ExperimentalFile){
            ExperimentalFile subFile = (ExperimentalFile)data;
            urls.put(nodeIdentifier(node), new URL(subFile.getDownloadLink()));
        }
        else {
            // add all the files from the children
            for (TreeNode child : node.getChildren()){
                addURLs(child,urls);
            }
        }
    }
    static public String nodeIdentifier(TreeNode node){
        TreeNodeRecord record = (TreeNodeRecord)node.getData();
        if (node.getParent() == null)
            return String.format("/%s",record.getId());
        return String.format("%s/%s", nodeIdentifier(node.getParent()),record.getId());
    }    
}
