/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.modern;

import java.io.Serializable;
import org.primefaces.model.TreeNode;
import org.rhwlab.UCSC.TrackHub;
import org.rhwlab.modern.Experiment;

/**
 *
 * @author gevirl
 */
public class TF extends ExpRecordBase implements Serializable,TreeNodeRecord {
    String gene ;
    String dbxref;
    String assembly;
    String geneType;
    
    public TF(String assembly,Experiment exp,TreeNode parent,String type){
        super(parent);
        this.gene = exp.getGene();
        this.exp = exp;
        this.assembly = assembly;
        this.dbxref = exp.getDbxref();
        this.geneType = type;
    }

    public TF(String assembly,String gene,TreeNode parent,String type){
        super(parent);
        this.gene = gene;
        exp = null;
        this.assembly = assembly;
        this.geneType = type;
    }
    public void setDbxref(String xref){
        this.dbxref = xref;
    }
    public String getUniqueId(){
        if (exp != null){
            return exp.getAccession();
        } else {
            return gene;
        }
    }
    @Override
    public String getId() {
        return gene;
    }
    @Override
    public String getStrain(){
        if (exp ==null) return "";
        String strain = exp.getStrain();
        return strain;
    }    
    public String getStrainLink(){
        if (exp != null){
            return exp.getStrainLink();
        }
        return "";
    }
    public boolean getStrainInExternalDB(){
        boolean r = !getStrainLink().equals("");
        return r;
    }
    public boolean getStrainNotInExternalDB(){
        boolean r = getStrainLink().equals("");
        return r;
    } 
    
    @Override
    public String getAccession() {
        if (exp == null) return "";
        return exp.getAccession();
    }

    @Override
    public String getMetaDataLink() {
        if (exp == null) return "";
        String acc = exp.getAccession();
        return String.format("https://www.encodeproject.org/experiments/%s/",acc);
    
    }
    @Override
    public String getInputMetaDataLink() {
        if (exp == null) return "";
        String inputAcc = exp.getInputAccession();
        return String.format("https://www.encodeproject.org/experiments/%s/",inputAcc);
    
    }  
    public String getInputAccession(){
        if (exp == null) return "";
        String inputAcc = exp.getInputAccession();
        return inputAcc;
    }

    @Override
    public String getRecordType() {
        return this.geneType;
    }
    

  
    @Override
    public String getWormbaseLink() {
        if (gene == null) return "";
        return String.format("http://www.wormbase.org/species/c_elegans/gene/%s/",gene);
    }    
    
    @Override
    public String getWormbase() {
        if (gene == null) return "";
        return "WormBase";
    } 
    @Override
    public String getFlybaseLink() {
        return String.format("http://flybase.org/reports/%s.html",dbxref);
    }    
    
    @Override
    public String getFlybase() {
        if (gene == null) return "";
        return "FlyBase";
    } 
    public String getExternalLink(){
        if (this.assembly.equals("ce11")|| this.assembly.equals("ce10")){
            return getWormbaseLink();
        }else {
            return getFlybaseLink();
        }
    }  
    public String getSpecies(){
        if (this.assembly.equals("ce11")|| this.assembly.equals("ce10")){
            return "worm";
        }else {
            return "fly";
        }        
    }
    @Override
    public String getBDGPLink() {
        return String.format("http://insitu.fruitfly.org/cgi-bin/ex/report.pl?ftype=1&ftext=%s",dbxref);
    }    
    
    @Override
    public String getBDGPLabel() {
        if (gene == null) return "";
        return "Homepage";
    }     
    public String getIdentifierTooltip(){
        return "Gene";
    }
    public Boolean getTooltip(){
        return true;
    }
    @Override
    public String getUcscLink() {
        if (exp==null) {
            int n = TrackHub.countHubFiles(this);
            if (n > 0){
                return String.format("http://genome.ucsc.edu/cgi-bin/hgTracks?db=%s&hubClear=http://waterston.gs.washington.edu/modERN/%s_hub.txt",
                        assembly,getId());
            }else {
                return "";
            }
        }
        if (!exp.isVisual()) return "";
        String acc = exp.getAccession();
        String ret = String.format("http://genome.ucsc.edu/cgi-bin/hgTracks?hubClear=https://www.encodeproject.org/experiments/%s/@@hub/hub.txt&db=%s",acc,assembly);
        return ret;
    }

    @Override
    public String getBrowser() {
        if (exp == null) {
            int n = TrackHub.countHubFiles(this);
            if (n > 0){
                return "TrackHub";
            } else {
                return "";
            }
        }
        if (!exp.isVisual()) return "";
        return "UCSC";
    } 
    @Override
    public String getDownload() {
        if (exp == null){
            return "All Stages for this Gene";
        }
        return "All DataTypes for this Gene";
    }  
    @Override
    public String getMicrographURL(){
        if (exp == null) return "";
        String ret = exp.getBiosample().getJpegUrl();
        if (ret == null) return "";
        return ret;
    }
    @Override
    public String getMicrographLabel(){
        if (exp == null){
            return "";
        }
        if (this.getMicrographURL().equals("")) return "";
        return "View";
    }
    @Override
    public String getDbxref(){
        return this.dbxref;
    }

    @Override
    public String getHubIdentifier() {
        TreeNodeRecord parent = (TreeNodeRecord)this.getParent();
        return String.format("%s/%s",parent.getHubIdentifier(),this.gene);
    }
}
