/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.modern;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.rhwlab.encode.EncodeUrl;
import org.rhwlab.encode.objects.Selection;
import org.rhwlab.fly.FlyBaseGenes;
import org.rhwlab.genetype.FlyGeneTypes;
import org.rhwlab.genetype.GeneTypes;
import org.rhwlab.genetype.WormGeneTypes;

/**
 *
 * @author gevirl
 */
public class SpeciesService implements Runnable {

 //   String urlString;
    File jsonDir;
//    File hubDir;
    String species;
    TreeMap<String, TreeMap<String, List<Experiment>>> byTFStage=new TreeMap<>(); // experiment accessions indexed by gene,life_stage
    TreeMap<String, TreeMap<String, List<Experiment>>> byStageTF=new TreeMap<>(); // experiment accessions indexed by life_stage,gene
    TreeMap<String,String> dbxrefs=new TreeMap<>();   // dbxref,common name
    TreeMap<String,String> commonNames=new TreeMap<>();  // commonName,dbxref
    FlyBaseGenes flyGenes;
    GeneTypes geneTypes;
    TreeMap<String, Experiment> expMap;  // all the released experiments (control and data)
    boolean complete = false;

    public SpeciesService(File jsonFile, String species) throws Exception {
 //       this.hubDir = hubDir;
        this.jsonDir = jsonFile;
 //       this.urlString = urlString;
        this.species = species;
        if (species.equalsIgnoreCase("fly")){
            flyGenes = new FlyBaseGenes();
            geneTypes = new FlyGeneTypes();
        } else {
            geneTypes = new WormGeneTypes();
        }
//        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
//        executor.scheduleAtFixedRate(this, 24, 24, TimeUnit.HOURS);  // rebuild from ENCODE every day      
    }

    public List<Experiment> getAllExperiments(){
        ArrayList<Experiment> ret = new ArrayList<>();
        for (TreeMap<String, List<Experiment>> stagemap : byTFStage.values()){
            for (List<Experiment> exps : stagemap.values()){
                ret.addAll(exps);
            }
        }
        return ret;
    }
    public TreeMap<String, List<Experiment>> getExpByStage(String gene) {
        return byTFStage.get(gene);
    }

    public TreeMap<String, List<Experiment>> getExpByTF(String stage) {
        return byStageTF.get(stage);
    }

    public List getAllTFs() {
        return new ArrayList<>(byTFStage.keySet());
    }

    public Set<String> getAllStages() {
        return byStageTF.keySet();
    }
    public String getGeneType(String gene){
        return this.geneTypes.getType(gene);
    }

    @Override
    public void run() {
        System.out.println(species);;
        TreeMap<String, TreeMap<String, List<Experiment>>> tempTFStage;
        tempTFStage = new TreeMap<>(new Comparator() {
            @Override
            public int compare(Object o1, Object o2) {
                String s1 = (String) o1;
                String s2 = (String) o2;
                return s1.compareToIgnoreCase(s2);
            }
        });
        TreeMap<String, TreeMap<String, List<Experiment>>> tempStageTF = new TreeMap<>();

        TreeMap<String,String> tempDbxrefs = new TreeMap<>();
        TreeMap<String,String> tempCommon = new TreeMap<>();
/*        
        EncodeUrl url = new EncodeUrl(urlString);
        try {
            url.getJsonWithoutAuthentication();
        } catch (Exception exc) {
            System.out.printf("URL failed: %s\n", species);
        }
        JsonObject obj = url.getJsonObject();
        JsonArray graph = obj.getJsonArray("@graph");
        int n = graph.size();
//  n = 20;  // limit for testing purpose

        // fetch the experiments indicated by the  search url
        FetchExperiments.accs  = new String[n];
        for (int i = 0; i < n; ++i) {
            JsonObject graphObj = (JsonObject) graph.get(i);
            FetchExperiments.accs[i] = graphObj.getString("accession");
        }
        
        FetchExperiments fetchExp = new FetchExperiments(0,n-1);
        ForkJoinPool pool = new ForkJoinPool();
        try {
            pool.invoke(fetchExp);
        } catch (Exception exc){
            exc.printStackTrace();
            return;
        } 
        if (fetchExp.isError()) return;
        ConcurrentHashMap<String, Experiment> expMap = fetchExp.getExperimentMap();
        
*/

        try {
            expMap = new TreeMap<>(); 
            org.rhwlab.encode.objects.Experiment encodeExp = new org.rhwlab.encode.objects.Experiment();
            Class cl = encodeExp.getClass();
            Selection select = new Selection(jsonDir,cl);            
//            PrintStream stream = new PrintStream(new File(hubDir,String.format("%sDCC.report",species)));
            for (int i = 0; i < select.getObjectCount() ; ++i) {
 //               JsonObject graphObj = (JsonObject) graph.get(i);
 //               String accession = graphObj.getString("accession");
                Experiment exp=null;
                JsonObject json = select.getEncodeObject(i).getJsonObject();
                if (json.getString("accession").equals("ENCSR660AYK")){
                    int skdhfusd=0;
                }
                try {
                    String expStatus = json.getString("status");
                    if (expStatus.equals("released")){
                        exp = new Experiment(json);
                        expMap.put(exp.accession, exp);
                    } else {
                        System.out.printf("Not Released: %s\n", json.getString("accession"));
                    }                    


                } catch (Exception exc) {
                    System.out.printf("Failed: %s\n", json.getString("accession"));
                }
            }
        } catch (Exception exc) {
            exc.printStackTrace();
            System.exit(0);
        }        

        // build the indexes
        for (Experiment exp : expMap.values()) {
// System.out.printf("Indexing: %s\n", exp.getAccession());
            if (!exp.isControl()) {
                if (exp.getDbxref()==null){
                    if (species.equalsIgnoreCase("fly")){
                        exp.setDbxref(this.flyGenes.getFBgnID(exp.getGene()));
                    }
                }
                if (exp.getDbxref()==null || exp.getGene() == null){
                    System.out.printf("Error in %s\n",exp.getAccession());
                    continue;
                }
                tempDbxrefs.put(exp.getDbxref(),exp.getGene());
                tempCommon.put(exp.getGene(),exp.getDbxref());
                
                // not an input experiment
                Experiment inputExp = expMap.get(exp.getInputAccession());
                if (inputExp == null) {
                     System.out.printf("Control %s for %s not released \n", exp.getInputAccession(),exp.accession);
                }
                exp.setInput(inputExp);

                TreeMap<String, List<Experiment>> stageMap = tempTFStage.get(exp.getGene());
                if (stageMap == null) {
                    stageMap = new TreeMap<>();
                    tempTFStage.put(exp.getGene(), stageMap);
                }
                List<Experiment> expList = stageMap.get(exp.getStage());
                if (expList == null) {
                    expList = new ArrayList<>();
                    stageMap.put(exp.getStage(), expList);
                }
                expList.add(exp);

                TreeMap<String, List<Experiment>> tfMap = tempStageTF.get(exp.getStage());
                if (tfMap == null) {
                    tfMap = new TreeMap<>();
                    tempStageTF.put(exp.getStage(), tfMap);
                }
                List<Experiment> list = tfMap.get(exp.getGene());
                if (list == null) {
                    list = new ArrayList<>();
                    tfMap.put(exp.getGene(), list);
                }
                list.add(exp);
            }
        }
        this.byStageTF = tempStageTF;
        this.byTFStage = tempTFStage;
        this.dbxrefs = tempDbxrefs;
        this.commonNames = tempCommon;
        complete = true;
    }

    public boolean isComplete(){
        return complete;
    }
    public String getSpecies() {
        return species;
    }
    public Collection<Experiment> getExperiments(){
        return this.expMap.values();
    }

    public boolean inDB(String tf){
        return dbxrefs.get(tf)!=null;
    }
    public String getCommonName(String dbxref){
        return this.dbxrefs.get(dbxref);
    }
    public String getAnyRandomName(){
        Random rnd = new Random();
        int n = rnd.nextInt(this.dbxrefs.size());
        int i= 0;
        String ret = null;
        for (String r : dbxrefs.values()){
            if (i == n){
                ret = r;
                break;
            }
            ++i;
        }
        return ret;
    }
    public String getDbxref(String commonName){
        return this.commonNames.get(commonName);
    }
/*    
    public void Serialize()throws Exception {
        for (String acc : expMap.keySet()){
            FileOutputStream outStream = new FileOutputStream(new File(hubDir,acc));
            ObjectOutputStream objStream = new ObjectOutputStream(outStream);
            Experiment exp = expMap.get(acc);
            objStream.writeObject(exp);
            objStream.close();
            outStream.close();
        }
    }
*/
}
