/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.modern;

import java.util.List;
import org.primefaces.model.TreeNode;

/**
 *
 * @author gevirl
 */
public class OrthologTF extends TF {
    List<String> orthologs;

    public OrthologTF(String assembly,String gene, TreeNode parent,String type) {
        super(assembly,gene, parent,type);
    }
    
    public OrthologTF(String assembly,Experiment exp, TreeNode parent,String type) {
        super(assembly, exp, parent,type);
    }
    
    public void setOrthologs(List<String> o){
        this.orthologs = o;
    }
    @Override
    public String getOrthologLabel(){
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        if (orthologs == null || orthologs.isEmpty()) return "";
        for (String ort : orthologs){
            if (!first){
                builder.append(" : ");
                
            }
            first = false;
            builder.append(ort);
        }
        return builder.toString();
    }
    public String getOrthologLink(){
        if (this.dbxref==null || orthologs == null || orthologs.isEmpty()) return "";
        if (this.dbxref.startsWith("WBGene")){
            return "faces/wormOrtholog.xhtml";
        }else {
            return "faces/flyOrtholog.xhtml";
        }
    }
    
}
