/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.modern;

import java.io.Serializable;
import org.primefaces.model.TreeNode;
import org.rhwlab.modern.Experiment;

/**
 *
 * @author gevirl
 */
public class LifeStage extends ExpRecordBase implements Serializable,TreeNodeRecord{
    String stage;
    String assembly;
    
    public LifeStage(String stage,TreeNode parent){
        super(parent);
        this.stage = stage;
        this.assembly = null;
        this.exp = null;
    }
    public LifeStage(String assembly,Experiment exp,TreeNode parent){
        super(parent);
        this.stage = exp.getStage();
        this.assembly = assembly;
        this.exp = exp;
    }
    @Override
    public String getDownload() {
        if (exp != null){
            return "All DataTypes for this Stage";
        }
        return "All TFs for this Stage";
    }    
    @Override
    public String getUniqueId(){
        if (exp != null){
            return exp.getAccession();
        } else {
            return this.stage;
        }
    }
    @Override
    public String getId(){
        return this.stage;
    }
    public String getStrainLink(){
        if (exp != null){
            return exp.getStrainLink();
        }
        return "";
    }
    public boolean getStrainInExternalDB(){
        boolean r = !getStrainLink().equals("");
        return r;
    }
    public boolean getStrainNotInExternalDB(){
        boolean r = getStrainLink().equals("");
        return r;
    }    

    @Override
    public String getAccession(){
        if (exp == null) return "";
        String acc = exp.getAccession();
        return acc;
    }

    @Override
    public String getMetaDataLink() {
        if (exp == null) return "";
        String acc = exp.getAccession();
        return String.format("https://www.encodeproject.org/experiments/%s/",acc);
    }
    @Override
    public String getInputMetaDataLink() {
        if (exp == null) return "";
        String inputAcc = exp.getInputAccession();
        return String.format("https://www.encodeproject.org/experiments/%s/",inputAcc);
    
    }  
    public String getInputAccession(){
        if (exp == null) return "";
        String inputAcc = exp.getInputAccession();
        return inputAcc;
    }  

    @Override
    public String getRecordType() {
        return "Stage";
    }
    
    public String getStrain(){
        if (exp == null) return "";
        return exp.getStrain();
    }
    @Override
    public String getUcscLink() {
        if (exp==null) return "";
        if (!exp.isVisual()) return "";
        String acc = exp.getAccession();
        String ret = String.format("http://genome.ucsc.edu/cgi-bin/hgTracks?hubClear=https://www.encodeproject.org/experiments/%s/@@hub/hub.txt&db=%s",acc,assembly);
        return ret;
    }

    @Override
    public String getBrowser() {
        if (exp == null) return "";
        if (!exp.isVisual()) return "";
        return "UCSC";
    }    
    public String getMicrographURL(){
        if (exp == null) return "";
        if (exp.getBiosample()==null) return"";
        String ret = exp.getBiosample().getJpegUrl();
        if (ret == null) return "";
        return ret;
    }
    public String getMicrographLabel(){
        if (exp == null){
            return "";
        }
        if (this.getMicrographURL().equals("")) return "";
        return "View";
    }   
    @Override
    public String getHubIdentifier() {
        TreeNodeRecord parent = (TreeNodeRecord)this.getParent();
        return String.format("%s/%s/%s/%s",parent.getHubIdentifier(),this.getId().replaceAll(" ", "_"),this.getStrain(),this.getAccession());
    }    
    
}
