/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.modern;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/**
 *
 * @author gevirl
 */
public class FileDescription implements Comparable {
    String replicate;
    String assembly;
    String outputType;
    String fileType;
 
    public FileDescription(){
        
    }
    public FileDescription(DCCFile dccFile){
        this.assembly = dccFile.getAssembly();
        if (dccFile.getAssembly()==null){
            this.assembly = "-";
        }
        
        this.fileType = dccFile.getFileType();
        this.outputType = dccFile.outputType;
        if (dccFile.replicates.length > 1){
            this.replicate = "C";
        } else {
            this.replicate = "d";
        }
    }

    public static void reportUploadStatus(Experiment exp,PrintStream stream,String resource)throws Exception {
        List<FileDescription> fileDescs = FileDescription.readDescriptions(resource);
        String tf = exp.gene;
        if (exp.control) tf = "Control";
        stream.printf("%s %s %s %s %s\n", exp.getAccession(),exp.species,tf,exp.stage,exp.strain);
        
        for (DCCFile dccFile : exp.getFiles()){
            FileDescription dccDesc = new FileDescription(dccFile);
            for (int i=0 ; i<fileDescs.size() ; ++i){
                if (fileDescs.get(i).compareTo(dccDesc)==0){
                    fileDescs.remove(i);
                    break;
                }
            }
        }
        
        for (FileDescription desc : fileDescs){
            stream.printf("   %s %s %s %s\n", desc.assembly,desc.replicate,desc.outputType,desc.fileType);
        }
    }
    public static List<FileDescription> readDescriptions(String resource)throws Exception {
        ArrayList<FileDescription> ret = new ArrayList<>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileDescription().getClass().getResourceAsStream(resource)));
        String line = reader.readLine();
        while (line != null){
            String[] tokens = line.split(",");
            FileDescription desc = new FileDescription();
            desc.replicate = tokens[0];
            desc.assembly = tokens[1];
            desc.outputType = tokens[2];
            desc.fileType = tokens[3];
            ret.add(desc);
            line = reader.readLine();
        }
        reader.close();
        return ret;
    }

    @Override
    public int compareTo(Object o) {
        FileDescription other = (FileDescription)o;
        
        int ret = this.replicate.compareTo(other.replicate);
        if (ret != 0) return ret;
        
        ret = this.assembly.compareTo(other.assembly);
        if (ret != 0) return ret;
        
        ret = this.outputType.compareTo(other.outputType);
        if (ret != 0) return ret;
        
        return this.fileType.compareTo(other.fileType);
    }
    
    static public void main(String[] args) throws Exception{
        List<FileDescription> descSet = FileDescription.readDescriptions("/org/rhwlab/encode/WormExperimentalFiles");
        int iuashdfi=0;
    }
}
