/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.modern;

import org.primefaces.model.TreeNode;
import org.rhwlab.modern.DCCFile;

/**
 *
 * @author gevirl
 */
public class ExperimentalFile extends RecordBase {
    DCCFile file;
    
    public ExperimentalFile(DCCFile file,TreeNode parent){
        super(parent);
        this.file = file;
    }
    @Override
    public String getDownload() {
        return "This File Only";
    }    
    @Override
    public String getId() {
        return file.submittedName;
    }

    @Override
    public String getRecordType() {
        return file.fileType;
    }

    @Override
    public String getAccession() {
        return file.getAccession();
    }

    @Override
    public String getMetaDataLink() {
        return String.format("https://www.encodeproject.org/files/%s/",getAccession());
    }

    @Override
    public String getFileType() {
        return file.getOutputType();
    }
   
   
    @Override
    public String getAssembly(){
        return file.getAssembly();
       
    }

    @Override
    public String getDownloadLink() {
        return String.format("https://www.encodeproject.org%s",file.getHref());
    }  

    
    @Override
    public String getHubIdentifier() {
        TreeNodeRecord parent = (TreeNodeRecord)this.getParent();
        return String.format("%s/%s/%s/%s",parent.getHubIdentifier(),"IP",this.getAccession(),this.getId());
        
    }        
}
