/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.modern;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import org.rhwlab.cgc.CGCStrain;
import org.rhwlab.encode.EncodeUrl;
import org.rhwlab.encode.objects.EncodeObject;

/**
 *
 * @author gevirl
 */
    public class Experiment implements Serializable {

        String accession;
        String stage;
        String inputAccession;
        Experiment input;
        String strain;
        TreeMap<String,DCCFile> files = new TreeMap<>();
        TreeMap<String,DCCFile> unreleased = new TreeMap<>();
        String gene;
        Biosample biosample;
        boolean control;
        String dbxref;  // either WBGene or FBgn
        List<String> orthologs;
        CGCStrain cgc;
        String donorUrl;
        boolean visual;
        String species;
        int[] biologicalReplicates;
        String status;
        
        public Experiment(String accession) throws Exception{
            this(EncodeObject.getFromEncode(accession));
        }
        
        public Experiment(JsonObject obj) throws Exception {
            
            this.accession = obj.getString("accession");
// System.out.println(this.accession)            ;
            status = obj.getString("status");
            visual = obj.getJsonObject("visualize")!=null;
            
           
            JsonArray filesObj = obj.getJsonArray("files");
            for (int i = 0; i < filesObj.size(); ++i) {
                DCCFile dccFile = new DCCFile(filesObj.getJsonObject(i));
                files.put(dccFile.getAccession(), dccFile);
            }
/*
            JsonArray origFiles = obj.getJsonArray("original_files");
            for (int i=0 ; i<origFiles.size() ; ++i){
                JsonObject orgFile = origFiles.getJsonObject(i);
                String orgFileStatus = orgFile.getString("status");
                if (!orgFileStatus.equals("revoked")&&!orgFileStatus.equals("archived")&&!orgFileStatus.equals("released")){
                    this.unreleased.put(orgFile.getString("accession"),new DCCFile(orgFile));
                }   
                
                String fileAcc = origFiles.getString(i);
                String acc = new File(fileAcc).getName();
                if (files.get(acc)==null){
                    try {
                        EncodeUrl fileUrl = new EncodeUrl(String.format("https://www.encodeproject.org%s?format=json", fileAcc));
                        fileUrl.getJson();
                        JsonObject fileObj = fileUrl.getJsonObject();
                        DCCFile dccFile = new DCCFile(fileObj);
                        if (!dccFile.getStatus().equals("revoked")&&!dccFile.getStatus().equals("archived")){
                            this.unreleased.put(dccFile.getAccession(),dccFile);
                        } 
                    } catch (Exception ex){
                        System.out.printf("Failed to get file: %s \n",acc);
                    }
                }

            }

*/
            JsonArray replicates = obj.getJsonArray("replicates");
            if (replicates.isEmpty()) {
                return;
            }
            biologicalReplicates = new int[replicates.size()];
            for (int i=0 ; i<replicates.size() ; ++i){
                biologicalReplicates[i] = replicates.getJsonObject(i).getInt("biological_replicate_number");
            }
            JsonObject rep1 = replicates.getJsonObject(0);
            JsonObject library = rep1.getJsonObject("library");
            if (library == null) {
                return;
            }
            JsonObject sample = library.getJsonObject("biosample");
            if (sample == null) {
                return;
            }
            JsonString stageObj = sample.getJsonString("life_stage");
            if (stageObj == null) {
                return;
            }
            this.stage = stageObj.getString();

            JsonObject donor = sample.getJsonObject("donor");
            strain = "";
            if (donor != null) {
                this.species = donor.getJsonObject("organism").getString("name");
                this.strain = donor.getString("strain_name", "");
                JsonString urlObj = donor.getJsonString("url");
                if (urlObj != null){
                    donorUrl = urlObj.getString();
                }else {
                    if (donor.getJsonObject("organism").getString("name").equals("dmelanogaster")){
                        JsonArray dbxs = donor.getJsonArray("dbxrefs");
                        if (dbxs.size()>0){
                            donorUrl = String.format("http://flystocks.bio.indiana.edu/Reports/%s.html",dbxs.getString(0).split(":")[1]);
                        }
                    }
                }
            }

            JsonArray possibleControls = obj.getJsonArray("possible_controls");
            int n = possibleControls.size();
            if (n > 0) {
                inputAccession = possibleControls.getJsonObject(0).getJsonString("accession").getString();
                JsonObject organism = sample.getJsonObject("organism");
                String organismName = organism.getString("name");
                if (organismName.equals("celegans")) {
                    biosample = new Biosample(sample);
                    if (!strain.equals("")){
//                        cgc = new CGCStrain(this.strain);
                    }
                }
            }


            control = false;
            JsonObject target = obj.getJsonObject("target");
            if (target!=null){
                JsonArray investigated = target.getJsonArray("investigated_as");
                for (int i = 0; i < investigated.size(); ++i) {
                    if (investigated.getString(i).equals("control")) {
                        control = true;
                        break;
                    }
                }            
                JsonString geneString = target.getJsonString("gene_name");

                if (geneString != null) {
                if (geneString.getString().startsWith("Sry")){
                    int sdhfuisd=0;
                }                    
                    gene = geneString.getString();
                } else {
                    gene = target.getString("label");
                }
                if (gene.startsWith("eGFP-")) {
                    gene = gene.substring(5);
                }   
                dbxref = null;
                JsonArray dbxrefArray = target.getJsonArray("dbxref");
                for (int i = 0; i < dbxrefArray.size(); ++i) {
                    String[] tokens = dbxrefArray.getString(i).split(":");
                    if (tokens[0].equals("WormBase") && tokens[1].startsWith("WBGene")) {
                        dbxref = tokens[1];
                        break;
                    } else if (tokens[0].equalsIgnoreCase("FlyBase") && tokens[1].startsWith("FBgn")) {
                        dbxref = tokens[1];
                    }
                }                
            }
        }

        public String getStatus(){
            return this.status;
        }
        public int[] getReplicates(){
            return this.biologicalReplicates;
        }
        public DCCFile[] getFiles() {
            return this.files.values().toArray(new DCCFile[0]);
        }
        public DCCFile[] getUnreleasedFiles() {
            return this.unreleased.values().toArray(new DCCFile[0]);
        }
        public void setInput(Experiment input) {
            this.input = input;
        }

        public String getStrain() {
            return this.strain;
        }

        public String getInputAccession() {
            return this.inputAccession;
        }

        public String getAccession() {
            return this.accession;
        }

        public Experiment getInput() {
            return this.input;
        }

        public String getGene() {
            return this.gene;
        }

        public String getStage() {
            return stage;
        }
        public String getSpecies(){
            return species;
        }

        public Biosample getBiosample() {
            return this.biosample;
        }

        public boolean isControl() {
            return control;
        }

        public String getDbxref() {
            return this.dbxref;
        }
        public void setDbxref(String dbx){
            this.dbxref = dbx;
        }
        public void setOrthologs(List<String> orthologs ){
            this.orthologs = orthologs;
        }
        public List<String> getOrthologs(){
            return this.orthologs;
        }
        public String getStrainLink(){
            if (dbxref == null) return "";
            
            if (dbxref.startsWith("WBGene")){
                if (cgc != null){
                    if (cgc.getUrl()==null){
                        return "";
                    }
                    return cgc.getUrl();
                }
                return "";
            }else {
                if (this.donorUrl != null){
                    return donorUrl;
                }
                return "";
            }
        }
        public boolean isVisual(){
            return this.visual;
        }
    }
