/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.modern;

import java.io.Serializable;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;

/**
 *
 * @author gevirl
 */
    public class DCCFile implements Serializable {

        String accession;
        String submittedName;
        String fileType; //fastq,bam,csv,bigWig, etc
        String outputType; //alignments,reads,peaks,etc
        String assembly; 
        String href;
        int[] replicates;
        String status;

        public DCCFile(JsonObject jsonObj) {
            accession = jsonObj.getString("accession");
            status = jsonObj.getString("status");
            submittedName = new java.io.File(jsonObj.getString("submitted_file_name")).getName();
            fileType = jsonObj.getString("file_type");
            outputType = jsonObj.getString("output_type");
            JsonString assemblyObj = jsonObj.getJsonString("assembly");
            if (assemblyObj != null) {
                assembly = assemblyObj.getString();
            } else {
                assembly = null;
            }
            href = jsonObj.getString("href");
            JsonArray jsonReps = jsonObj.getJsonArray("biological_replicates");
            if (jsonReps != null){
                replicates = new int[jsonReps.size()];
                for (int i=0 ; i<jsonReps.size() ; ++i){
                    replicates[i] = jsonReps.getInt(i);
                }
            }
        }

        public String getAccession() {
            return this.accession;
        }

        public String getSubmittedFileName() {
            return this.submittedName;
        }

        public String getFileType() {
            return this.fileType;
        }

        public String getOutputType() {
            return this.outputType;
        }

        public String getHref() {
            return this.href;
        }

        public String getAssembly() {
            return this.assembly;
        }
        public int[] getReplicates(){
            return this.replicates;
        }
        public String getStatus(){
            return this.status;
        }
    }
