/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.qa;

import java.io.PrintStream;
import java.util.TreeMap;
import org.rhwlab.encode.objects.EncodeObject;
import org.rhwlab.encode.objects.Selection;
import org.rhwlab.modern.DCCFile;
import org.rhwlab.modern.Experiment;

/**
 *
 * @author gevirl
 */
public class ChipSeqUpload {
    String[] assemblies;
    Experiment exp;
    PrintStream stream;
    
    public ChipSeqUpload(Experiment exp,String[] assemblies,PrintStream stream){
        this.assemblies = assemblies;
        this.exp = exp;
        this.stream = stream;
    }
    
    // report missing files for the IP Experiment to stream
    public void reportExperimentIP(){
        stream.printf("%s,%s,%s,%s,%s,%s\n", exp.getAccession(),exp.getSpecies(),exp.getGene(),exp.getStage(),exp.getStrain(),exp.getStatus());
        for (int replicate : exp.getReplicates()){
            reportIP_Replicate(replicate);
        }
        for (String assembly : assemblies){
            reportIP_Assembly(assembly);
        }
        reportInput();
        stream.println();
    }
    private void reportIP_Replicate(int rep){
        // find a fastq file for the replicate
        if (findFile(exp.getFiles(),rep,null,reads,fastq)==null){
            DCCFile unreleased = findFile(exp.getUnreleasedFiles(),rep,null,reads,fastq);
            if (unreleased == null) {
                stream.printf("   replicate %d,reads,fastq\n",rep);
            } else {
                stream.printf("   replicate %d,reads,fastq   %s\n",rep,unreleased.getStatus());
            }
        } 
        for (String assembly : assemblies){
            reportIP_ReplicateAssembly(rep,assembly);       
        }
    }
    // report the single replicate for the assembly
    private void reportIP_ReplicateAssembly(int rep,String assembly){
        for (int i=0 ; i<repAssembly.length ; i = i +2){
            if (findFile(exp.getFiles(),rep,assembly,repAssembly[i],repAssembly[i+1])==null){
                DCCFile unreleased = findFile(exp.getUnreleasedFiles(), rep, assembly, repAssembly[i], repAssembly[i + 1]);
                if (unreleased == null){
                    stream.printf("   replicate %d,assembly %s,%s,%s\n",rep,assembly,outTypes[repAssembly[i]],fileTypes[repAssembly[i+1]]);
                } else {
                    stream.printf("   replicate %d,assembly %s,%s,%s   %s\n",rep,assembly,outTypes[repAssembly[i]],fileTypes[repAssembly[i+1]],unreleased.getStatus());
                }
            }
        }
    }
    // report the combined replicate for the assembly
    private void reportIP_Assembly(String assembly){
        for (int i=0 ; i<ipAssembly.length ; i = i +2){
            if (findFile(exp.getFiles(),exp.getReplicates(),assembly,ipAssembly[i],ipAssembly[i+1])==null){
                DCCFile unreleased = findFile(exp.getUnreleasedFiles(), exp.getReplicates(), assembly, ipAssembly[i], ipAssembly[i + 1]);
                if (unreleased == null){
                    stream.printf("   combined,assembly %s,%s,%s\n",assembly,outTypes[ipAssembly[i]],fileTypes[ipAssembly[i+1]]);
                } else {
                    stream.printf("   combined,assembly %s,%s,%s   %s\n",assembly,outTypes[ipAssembly[i]],fileTypes[ipAssembly[i+1]],unreleased.getStatus());
                }
            }
        }        
    }
    private void reportInput(){
        Experiment inputExp = exp.getInput();
        if (inputExp == null){
            stream.println("Missing input control");
            return;
        }
        stream.printf("   Input Experiment %s\n",inputExp.getAccession());
        for (int replicate : inputExp.getReplicates()){
            if (findFile(inputExp.getFiles(),replicate,null,reads,fastq)==null){
                DCCFile unreleased = findFile(inputExp.getUnreleasedFiles(),replicate,null,reads,fastq);
                if (unreleased == null){
                    stream.printf("      replicate %d,reads,fastq\n", replicate);
                } else {
                    stream.printf("      replicate %d,reads,fastq   %s\n", replicate,unreleased.getStatus());
                }
            }
        }
        for (String assembly : assemblies){
            for (int i=0 ; i<inputAssembly.length ; i=i+2){
                if (findFile(inputExp.getFiles(),inputExp.getReplicates(),assembly,inputAssembly[i],inputAssembly[i+1])==null){
                    DCCFile unreleased = findFile(inputExp.getUnreleasedFiles(),inputExp.getReplicates(),assembly,inputAssembly[i],inputAssembly[i+1]);
                    
                    if (unreleased == null){
                        stream.printf("      combined,assembly %s,%s,%s\n",assembly,outTypes[inputAssembly[i]],fileTypes[inputAssembly[i+1]]);
                    }else {
                        stream.printf("      combined,assembly %s,%s,%s   %s\n",assembly,outTypes[inputAssembly[i]],fileTypes[inputAssembly[i+1]],unreleased.getStatus());
                    }
                }
            }
        }
    }
    
    // if reps is int[] then looking to find the combined replicate
    // otherwise looking for the numbered single replicate
    private DCCFile findFile(DCCFile[] dccFiles,Object reps,String assembly,int outType,int fileType){

        for (DCCFile dccFile : dccFiles){
            if (assembly == null || assembly.equals(dccFile.getAssembly())){
                if (outTypes[outType].equals(dccFile.getOutputType())){
                    if (fileTypes[fileType].equals(dccFile.getFileType())){
                        // file criteria have been matched
                        int[] dccReps = dccFile.getReplicates();
                        if (reps instanceof int[]){
                            if (((int[]) reps).length == dccReps.length){  // is there a file combining replicates that matches criteria
                                return dccFile;
                            }
                        } else {
                            // rep is an single integer                            
                            if (dccReps.length==1 && dccReps[0] == (Integer)reps){
                                return dccFile;
                            }
                        }
                    }
                }
            }
        }
        return null;
    }
    static public void report(java.io.File dir,String[] assemblies)throws Exception {
        Class cl = new org.rhwlab.encode.objects.Experiment().getClass();
        Selection selection = new Selection(dir,cl);
        String reportFile = new java.io.File(dir,"UploadReport").getPath();
        PrintStream stream = new PrintStream(reportFile);
        
        TreeMap<String,Experiment> expMap = new TreeMap<>();
        int i=0;
        for (int r=0 ; r<selection.getObjectCount() ; ++r){
            EncodeObject obj = selection.getEncodeObject(r);

            System.out.printf("%d %s\n",i,obj.getJsonObject().getString("accession"));

            ++i;
            Experiment exp = new Experiment(obj.getJsonObject());
            expMap.put(exp.getAccession(),exp);
            
        }
        
        // set up the link between  data and control
        for (String acc : expMap.keySet()){
            Experiment exp = expMap.get(acc);
            if (!exp.isControl()){
                String inpAccession = exp.getInputAccession();
                if (inpAccession != null){
                    Experiment control = expMap.get(inpAccession);
                    exp.setInput(control);
                }

            }
        }
        for (Experiment exp : expMap.values()){

            if (!exp.isControl()){
//                ChipSeqUpload upload = new ChipSeqUpload(exp,wormAssembly,wormStream);
                ChipSeqUpload upload = new ChipSeqUpload(exp,assemblies,stream);
                upload.reportExperimentIP();  
            }
        }
        stream.close();
    }
    static public void main(String[] args)throws Exception{
//        report(new java.io.File("/net/waterston/vol2/home/gevirl/WormChipSeqExperiments"),wormAssembly);
        report(new java.io.File("/net/waterston/vol2/home/gevirl/FlyChipSeqExperiments"),flyAssembly);

    }
    static String[] wormAssembly = {"ce10","ce11"};
    static String[] flyAssembly ={"dm3","dm6"};
    
    static int reads = 0;
    static int align = 1;
    static int signal = 2;
    static int depth = 3;
    static int control = 4;
    static int peaks = 5;
    static int optimal = 6;
    
    static int fastq = 0;
    static int bam = 1;
    static int bigWig = 2;
    static int bigBed = 3;
    static int bed = 4;
    
    static int[] repAssembly = {
        align,bam,
        signal,bigWig,
        depth,bigWig,
        control,bigWig,
        peaks,bigBed,
        peaks,bed
    };
    static int[] ipAssembly = {
        signal,bigWig,
        depth,bigWig,
        control,bigWig,
        peaks,bigBed,
        peaks,bed,
        optimal,bigBed,
        optimal,bed
    };
    static int[] inputAssembly = {
        align,bam,
        signal,bigWig,
        depth,bigWig
    };
    static String[] outTypes = {
        "reads",
        "alignments",
        "signal of unique reads",
        "read-depth normalized signal",
        "control normalized signal",
        "peaks",
        "optimal idr thresholded peaks"
    };
    static String[] fileTypes = {
        "fastq",
        "bam",
        "bigWig",
        "bigBed narrowPeak",
        "bed narrowPeak"       
    };
}
