/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.ortholog;

import java.io.Serializable;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.primefaces.model.TreeNode;
import org.rhwlab.modern.ReferenceGenome;
import org.rhwlab.modern.ViewBase;
import static org.rhwlab.modern.ViewBase.addURLs;

/**
 *
 * @author gevirl
 */
public class OrthologView extends ViewBase implements Serializable {
    
//    ReferenceGenome genome;
//    OrthologService service;
    String tf;
//    TreeNode root;
 //   TreeNode[] selectedNodes;
//    TreeMap<String,URL> urlsMap = new TreeMap<>();
    String title;
    
    public OrthologView(){
        HttpServletRequest req = (HttpServletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
        tf = req.getParameter("TF");  
        
    }
    public String getTitle(){
        title = "ChipSeq";
        if (service != null && tf !=null){
            String source = service.getCommonName(tf);
            if (source != null){
                title = String.format("ChipSeq for Ortholog of %s",service.getCommonName(tf));
            }
        }
        return title;
    }
    public void setService(OrthologService service){
        this.service = service;
    }
  
    public void setGenomes(ReferenceGenome gen){
        this.genomes = gen;
    }
    public TreeNode getRoot(){
        if (root == null){
            buildTree();
        }
        return root;
    }
    public String getTF(){
        return tf;
    }
    private void buildTree(){
        if (tf == null) return;
        if (tf.startsWith("WBGene")){
            List<String> flys = service.getWormOrthologsCommonName(tf);
            root = service.createTree("fly",flys,genomes.getFly());
        }else {
            List<String> worms = service.getFlyOrthologsCommonName(tf);
            root = service.createTree("worm",worms,genomes.getWorm());            
        }
        int iusfhuis=0;
    }
    public TreeNode[] getSelectedNodes() {
        return selectedNodes;
    }
    public void setSelectedNodes(TreeNode[] selectedNodes) throws Exception {
        this.selectedNodes = selectedNodes;
        urlsMap.clear();
        if (selectedNodes == null) return;
        for (TreeNode treeNode : selectedNodes){
            addURLs(treeNode, urlsMap);
        }        
    }    

    @Override
    public String getZipFileName() {
        return String.format("%s_Ortholog.zip",tf);

    }
}
