/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.ortholog;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.primefaces.model.TreeNode;
import org.rhwlab.UCSC.AggregateBed;
import org.rhwlab.UCSC.TrackHub;
import org.rhwlab.modern.ControlFile;
import org.rhwlab.modern.DCCFile;
import org.rhwlab.modern.Experiment;
import org.rhwlab.modern.ExperimentalFile;
import org.rhwlab.modern.FileType;
import org.rhwlab.modern.FlyService;
import org.rhwlab.modern.LifeStage;
import org.rhwlab.modern.OrthologTF;
import org.rhwlab.modern.ReferenceGenome;
import org.rhwlab.modern.Species;
import org.rhwlab.modern.SpeciesService;
import org.rhwlab.modern.TF;
import org.rhwlab.modern.ViewByTF;
import org.rhwlab.modern.WormService;
import org.rhwlab.encode.qa.ChipSeqUpload;

/**
 * @author gevirl
 *
 */
public class OrthologService implements Serializable,Runnable {
    static String[] wormAssembly = {"ce10","ce11"};
    static String[] flyAssembly ={"dm3","dm6"};
    File hubDir;
   
  
    Map<String,List<String>> flyOrthologs;
    Map<String,List<String>> wormOrthologs;
    WormService wormService = new WormService();
    FlyService flyService = new FlyService();
    Date updated;
    

    
    // construct a service and start the updating thread
    public OrthologService()throws Exception {
        this(true);
    }
    public OrthologService(boolean updating)throws Exception {
        if (updating){
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
            executor.scheduleAtFixedRate(this, 0, 24, TimeUnit.HOURS);  // rebuild from ENCODE every day             
        }
        hubDir = new File("/data/www/site/waterston/html/modERN");
        hubDir = new File("/net/waterston/vol2/home/gevirl/trackhubs/modERN");  
        this.buildIt();
    }
    @Override
    public void run() {
        try {
/*            
            OrthologService newService = new OrthologService(false);  // does not start another updating thread
            newService.buildIt();
            this.flyOrthologs = newService.flyOrthologs;
            this.flyService = newService.flyService;
            this.wormOrthologs = newService.wormOrthologs;
            this.wormService = newService.wormService;

            // build the track hubs           
            if (hubDir.exists()){
                formTrackHub(hubDir,"worm",wormAssembly,newService);
                formTrackHub(hubDir,"fly",flyAssembly,newService);
            }
*/            
            updated = new Date();
        } catch (Exception exc){
            exc.printStackTrace();
        }
    } 

    public void checkUploadStatus(File dir) throws Exception {
        // check on upload status
        PrintStream stream = new PrintStream(new File(dir,"WormMissingReport"));
        for (Experiment exp : wormService.getExperiments()){
            if (!exp.isControl()){
                ChipSeqUpload wormUpload = new ChipSeqUpload(exp,wormAssembly,stream);
                wormUpload.reportExperimentIP();
            }
        }
        stream.close();
        stream = new PrintStream(new File(dir,"FlyMissingReport"));
        for (Experiment exp : flyService.getExperiments()){
            if (!exp.isControl()){
                ChipSeqUpload flyUpload = new ChipSeqUpload(exp,flyAssembly,stream);
                flyUpload.reportExperimentIP();
            }
        } 
        stream.close();        
    }
    // form a trackhub for given species and assemblies
    private void formTrackHub(File hubDir,String species,String[] assemblies,OrthologService service)throws Exception {
        TreeMap<String,TF> tfs = new TreeMap<>();

        // make a view and aggregate tracks for each assembly
        ViewByTF[] views = new ViewByTF[assemblies.length];
        TreeNode[] roots = new TreeNode[assemblies.length];
        for (int a=0 ; a<assemblies.length ; ++a){
            
            String assembly = assemblies[a];
// System.out.printf("Species: %s   Assembly: %s\n",species,assembly);            
            File assemblyDir = new File(hubDir,assembly);

            ReferenceGenome refGenome = new ReferenceGenome();
            refGenome.setAssembly(species, assembly);

            views[a] = new ViewByTF();
            views[a].setSpecies(species);
            views[a].setGenomes(refGenome);
            views[a].setService(service); 
            roots[a] = views[a].getRoot();
            for (TreeNode node : views[a].getRoot().getChildren()){
                TF tf = (TF)node.getData();
                tfs.put(tf.getId(),tf);
            }
            
            AggregateBed aggBed = new AggregateBed(views[a].getRoot(),"optimal idr thresholded peaks","gz");
            File narrowBedFile = new File(assemblyDir, "narrowPeak.bed");
            File narrowBBFile = new File(assemblyDir, "narrowPeak.bb");
            File singleBedFile = new File(assemblyDir,"singlePeak.bed");
            File singleBBFile = new File(assemblyDir,"singlePeak.bb");

            aggBed.writeTo(narrowBedFile);
            String cmd = String.format("/net/waterston/vol9/bedToBigBed -type=bed6+4 -as=/net/waterston/vol9/narrowPeak.as  %s /net/waterston/vol9/%s.chrom.sizes %s",
                    narrowBedFile.getPath(),assembly,narrowBBFile.getPath());
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();

            aggBed.writePointBedTo(singleBedFile);
            cmd = String.format("/net/waterston/vol9/bedToBigBed -type=bed6+3  %s /net/waterston/vol9/%s.chrom.sizes %s",
                    singleBedFile.getPath(),assembly,singleBBFile.getPath());
            p = Runtime.getRuntime().exec(cmd);
            p.waitFor(); 
            
            Runtime.getRuntime().exec(String.format("chmod 666 %s",narrowBBFile.getPath()));
            Runtime.getRuntime().exec(String.format("chmod 666 %s",singleBBFile.getPath()));
        }
        
        // form a hub and html description for each tf
        for (String tf : tfs.keySet()){
            TrackHub.formHub(tf,roots,hubDir,species,assemblies);
            TrackHub.formTFhtml(tfs.get(tf), hubDir);
        }
        TrackHub.formHub(null,roots,hubDir,species,assemblies);
    }
    private void buildIt()throws Exception{
        wormService.run();
        flyService.run(); 
        flyOrthologs = this.buildOrthologMap("/org/rhwlab/encode/ortholog/FBgnToWBGene.all.orthologs", flyService, wormService);
        wormOrthologs = this.buildOrthologMap("/org/rhwlab/encode/ortholog/WBGeneToFBgn.all.orthologs", wormService, flyService);

        for (Experiment exp : wormService.getAllExperiments()){
            if (exp.getDbxref() != null){
                exp.setOrthologs(this.getWormOrthologsCommonName(exp.getDbxref()));
            }
            else {
                System.out.printf("No dbxref for %s\n",exp.getAccession());
            }
        }
        for (Experiment exp : flyService.getAllExperiments()){
            if (exp.getDbxref()!=null){
                exp.setOrthologs(this.getFlyOrthologsCommonName(exp.getDbxref()));
            }else {
                System.out.printf("No dbxref for %s\n",exp.getAccession());
            }
        }            
    }
    private TreeMap buildOrthologMap(String file,SpeciesService service1,SpeciesService service2)throws Exception {
        TreeMap<String,List<String>> ret = new TreeMap<>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(file)));
        String line = reader.readLine();
        while(line != null){
            String[] tokens = line.split("\t");
            if (service1.inDB(tokens[0]) && service2.inDB(tokens[1])){
                List<String> list = ret.get(tokens[0]);
                if (list == null){
                    list = new ArrayList<>();
                    ret.put(tokens[0],list);
                }
                list.add(tokens[1]);            
            }
            line = reader.readLine();
        }
        reader.close();
        return ret;
    }
   
    // create a by TF,Stage tree for all the TFs
    public TreeNode createTree(String species,String genome){
        SpeciesService service = wormService;
        if (species.equals("fly")){
            service = flyService;
        }         
        List<String> tfs = service.getAllTFs();
        return createTree(species,tfs,genome);

    } 
    // create a by TF,Stage tree for a list of TFs
    public TreeNode createTree(String species,List<String> tfs,String genome){
        SpeciesService service = wormService;
        if (species.equals("fly")){
            service = flyService;
        } 
        TreeNode root = new Species(genome,species,null);
        for (String gene : tfs){
            TF geneNode =null;
            TreeMap<String,List<Experiment>> stages = service.getExpByStage(gene);
            for (String stage : stages.keySet()){
                List<Experiment> exps = stages.get(stage);
                for (Experiment exp : exps){
                    if (geneNode == null){
                        if (this.getOrthologs(exp.getDbxref()).isEmpty()){
                            geneNode = new TF(genome,gene,root,service.getGeneType(gene));
                        }else {
                            geneNode = new OrthologTF(genome,gene,root,service.getGeneType(gene));
                            ((OrthologTF)geneNode).setOrthologs(this.getOrthologsCommonName(exp.getDbxref()));
                        }
                    }
                    geneNode.setDbxref(exp.getDbxref());
                    TreeNode stageNode = new LifeStage(genome,exp,geneNode);
                    addFiles(stageNode,exp,genome);
                }
            }
        }
        return root;
    }   
    public TreeNode createByStageTree(String species,String genome){
        SpeciesService service = wormService;
        if (species.equals("fly")){
            service = flyService;
        }         
        TreeNode root = new Species(genome,species,null);
        for (String stage : service.getAllStages()){
            TreeNode stageNode = new LifeStage(stage,root);
            TreeMap<String,List<Experiment>> tfs = service.getExpByTF(stage);
            for (String tf : tfs.keySet()){
                List<Experiment> exps = tfs.get(tf);
                for (Experiment exp : exps){
                    TreeNode tfNode;
                    if (this.getOrthologs(exp.getDbxref()).isEmpty()){
                        tfNode = new TF(genome,exp,stageNode,service.getGeneType(tf));
                    }else {
                        tfNode = new OrthologTF(genome,exp,stageNode,service.getGeneType(tf));
                        ((OrthologTF)tfNode).setOrthologs(this.getOrthologsCommonName(exp.getDbxref()));
                    }
                    addFiles(tfNode,exp,genome);
                }
            }
        }
        return root;        
    }       
    public void addFiles(TreeNode root,Experiment exp,String genome){
        TreeMap<String,List<DCCFile>> fileMap = new TreeMap<>();  // lists of files indexed filetype 
        mapFilesForAccession(exp,genome,fileMap);
        
        TreeMap<String,List<DCCFile>> controlFileMap = new TreeMap<>();   // lists of control files indexed filetype
        if (exp.getInput() != null){
            mapFilesForAccession(exp.getInput(),genome,controlFileMap);
        }
        
        for (String key : fileMap.keySet()){
            List<DCCFile> list = fileMap.get(key);
            TreeNode keyNode = new FileType(key,genome,root);
            
            for (DCCFile file : list){
                TreeNode fileNode = new ExperimentalFile(file,keyNode);
            }             
            List<DCCFile> cFiles = controlFileMap.get(key);
            if (cFiles != null){
            for (DCCFile file : cFiles){
                TreeNode fileNode = new ControlFile(file,keyNode);
                }
            }  
        }
    }
    // sorts the files of an experiment into output type categories
    private  void mapFilesForAccession(Experiment exp,String genome,TreeMap<String,List<DCCFile>> fileMap){
        DCCFile[] files = exp.getFiles();
        
        for (int i=0 ; i<files.length ; ++i)    {
            String assembly = files[i].getAssembly();
            if (assembly != null && !assembly.equals(genome)) continue;
            
            String key = files[i].getOutputType();
            List<DCCFile> list = fileMap.get(key);
            if (list == null){
                list = new ArrayList<>();
                fileMap.put(key,list);
            }
            list.add(files[i]);
        } 
    }  
    // return the orthologs(common name of worm TF)  given a fly TF FBgn
    public List<String> getFlyOrthologsCommonName(String flydbxref){
        ArrayList<String> ret = new ArrayList<>();        
        for (String dbxref : getFlyOrthologs(flydbxref)){
            String commonName = wormService.getCommonName(dbxref);
            if (commonName != null){
                ret.add(commonName);
            } 
        }
        return ret;
    }
    public List<String> getWormOrthologsCommonName(String wormdbxref){
        ArrayList<String> ret = new ArrayList<>();    
        
        for (String dbxref : getWormOrthologs(wormdbxref)){
            String commonName = flyService.getCommonName(dbxref);
            if (commonName != null){
                ret.add(commonName);
            }
        }
        return ret;
    }
    public List<String> getOrthologs(String id){
        List<String> ret = getWormOrthologs(id);
        if (ret.isEmpty()){
            ret = getFlyOrthologs(id);
        }
        return ret;
    }
    public List<String> getOrthologsCommonName(String dbxref){
        List<String> ret = this.getWormOrthologsCommonName(dbxref);
        if (ret.isEmpty()){
            ret = this.getFlyOrthologsCommonName(dbxref);
        }
        return ret;
    }
    // get the worm orthologs (in FBGn ids) given a WBGene id
    public List<String> getWormOrthologs(String dbxref){
        List<String> ret = this.wormOrthologs.get(dbxref);
        if (ret == null) ret = new ArrayList<>();
        return ret;
    }
    public List<String> getFlyOrthologs(String dbxref){
        List<String> ret= this.flyOrthologs.get(dbxref);
        if (ret == null) ret = new ArrayList<>();
        return ret;
    }  
    public String getCommonName(String dbxrefName){
        String ret = this.flyService.getCommonName(dbxrefName);
        if (ret ==null){
            ret = this.wormService.getCommonName(dbxrefName);
        }
        return ret;
    }
    public String getUpdatedLast() {
        DateFormat df = DateFormat.getDateTimeInstance(DateFormat.FULL, DateFormat.FULL);
        if (updated == null){
            return "currently being updated - try again later";
        }
        return df.format(updated);
    }    
    static public void main(String[] args)throws Exception {
        OrthologService service = new OrthologService(false);
        service.buildIt();
        service.checkUploadStatus(new File("/net/waterston/vol2/home/gevirl"));
        int iasdhfu=0;
    }


}
