/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.objects;

import java.io.FileInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.text.DateFormat;
import java.util.Date;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonWriter;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.rhwlab.encode.EncodeUrl;
import org.rhwlab.encode.RNASeq.UrlDisplay;

/**
 *
 * @author gevirl
 */
public class Selection implements Serializable {

    Class<EncodeObject> encodeObjectClass;
    java.io.File directory;
    java.io.File[] files;
    JTable table;

    public Selection(java.io.File dir, Class c) throws Exception {
        this.directory = dir;
        this.encodeObjectClass = c;
        this.files = dir.listFiles();
    }

    public Selection(Class c) throws Exception {
//        public Selection(Class<EncodeObject> c)throws Exception {
        this.encodeObjectClass = c;
    }

    public int getObjectCount() {
        return this.files.length;
    }

    public EncodeObject getEncodeObject(String acc) throws Exception {
        return getEncodeObject(new java.io.File(directory, acc));
    }

    public EncodeObject getEncodeObject(java.io.File acc) throws Exception {
        JsonReader reader = javax.json.Json.createReader(new FileInputStream(acc));

        JsonObject jsonObj = reader.readObject();
        reader.close();

        EncodeObject ret = this.encodeObjectClass.newInstance();
        ret.setJsonObject(jsonObj);
        int isdertertfg = 0;
        return ret;
    }

    public EncodeObject getEncodeObject(int i) throws Exception {
// System.out.printf("%d - %s\n",i,files[i].getPath());
        return getEncodeObject(files[i]);
    }

    public void saveToDirectory(java.io.File dir) throws Exception {
        saveToDirectory(dir, true);
    }

    // gets all the objects from DCC and saves them to directory
    public void saveToDirectory(java.io.File dir, boolean expand) throws Exception {
        Path outPath = null;
        EncodeObject obj = encodeObjectClass.newInstance();
        EncodeUrl url = new EncodeUrl(obj.getSelectionUrl());
        url.getJson();
        JsonObject jsonObj = url.getJsonObject();

        JsonArray list = jsonObj.getJsonArray("@graph");
        for (int i = 0; i < list.size(); ++i) {
            JsonObject listObj = list.getJsonObject(i);
            JsonString jsonAcc = listObj.getJsonString("@id");
            if (jsonAcc != null) {
                String id = jsonAcc.getString();
 // System.out.printf("%d %s\n", i, id);
                JsonObject fromEncode = EncodeObject.getFromEncode(id);
                obj = (EncodeObject) encodeObjectClass.newInstance();
                obj.setJsonObject(fromEncode);
                obj.expand();
                int asiofjisd = 0;
                // save the json object in a file in the directory
                java.io.File outFile = new java.io.File(dir, id);
                outPath = outFile.toPath();
                java.nio.file.Files.createDirectories(outPath.getParent());

                PrintStream stream = new PrintStream(outFile);
                JsonWriter writer = javax.json.Json.createWriter(stream);

                writer.write(obj.getJsonObject());
                stream.println();
                stream.flush();
                writer.close();

            } else {
                int auishdfiudsh = 0;
            }
        }
        this.directory = outPath.getParent().toFile();
        this.files = this.directory.listFiles();
    }

    public JScrollPane toTable() throws Exception {
        TreeSet<String> columnSet = new TreeSet<>();
        table = new JTable();

        // add all the rows
        DefaultTableModel model = new DefaultTableModel();
        for (int r = 0; r < this.getObjectCount(); ++r) {
            EncodeObject obj = this.getEncodeObject(r);
            TreeMap<String, Object> map = obj.asMap();

            if (!map.isEmpty()) {
                this.addColumns(map, model, columnSet);
                model.addRow(obj.asMap().values().toArray());
            }
        }
        table.setModel(model);

        // size the columns
        TableCellRenderer headRend = table.getTableHeader().getDefaultRenderer();
        for (int c = 0; c < table.getColumnCount(); ++c) {
            TableColumn column = table.getColumnModel().getColumn(c);
            int headWidth = headRend.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, 0).getPreferredSize().width;
            int cellWidth = table.getDefaultRenderer(model.getColumnClass(c)).getTableCellRendererComponent(table, longestValue(table, c), false, false, 0, c).getPreferredSize().width;
            column.setPreferredWidth(Math.max(headWidth, cellWidth));
        }

        // add editor for accessions
        for (int c = 0; c < table.getColumnCount(); ++c) {
            TableColumn column = table.getColumnModel().getColumn(c);
            String head = (String) column.getHeaderValue();
            if (head.contains("Accession")) {
                column.setCellEditor(new UrlDisplay());
            }
        }

        table.setAutoCreateRowSorter(true);
        table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        return new JScrollPane(table);
    }

    private void addColumns(TreeMap<String, Object> map, DefaultTableModel model, TreeSet<String> columnSet) {
        for (String key : map.keySet()) {
            if (!columnSet.contains(key)) {
                columnSet.add(key);
                model.addColumn(key);
            }
        }
    }

    private String longestValue(JTable table, int c) {
        Object longest = null;
        int len = 0;
        for (int r = 0; r < table.getRowCount(); ++r) {
            Object obj = table.getValueAt(r, c);
            if (obj != null) {
                int l = obj.toString().length();
                if (l > len) {
                    longest = obj;
                    len = l;
                }
            }
        }
        if (longest == null) {
            return "";
        }
        return longest.toString();
    }

    public String getDirectory() {
        return this.directory.getPath();
    }

    public void setDirectory(String dir) {
        this.directory = new java.io.File(dir);
        this.files = this.directory.listFiles();
    }

    public String getUpdatedLast() {
        long l = this.directory.getParentFile().lastModified();
        Date updated = new Date(l);
        DateFormat df = DateFormat.getDateTimeInstance(DateFormat.FULL, DateFormat.FULL);
        return df.format(updated);
    }

    public JTable getTable(){
        return this.table;
    }
    // build and save the selections 
    static public void main(String[] args) throws Exception {
        /*        
        EncodeObject f = new Replicate();
        Selection select = new Selection((Class<EncodeObject>)f.getClass());
        select.saveToDirectory(new java.io.File("/nfs/waterston/DCCKnockDown"));
         */
        EncodeObject f = new WormDonor();
        Selection select = new Selection((Class<EncodeObject>) f.getClass());
        select.saveToDirectory(new java.io.File("/nfs/waterston/DCCKnockDown"));
        /*       
        f = new Donor();
        select = new Selection((Class<EncodeObject>)f.getClass());
        select.saveToDirectory(new java.io.File("/nfs/waterston/DCCKnockDown")); 
        
        f = new File();      
        select = new Selection((Class<EncodeObject>)f.getClass());
        select.saveToDirectory(new java.io.File("/nfs/waterston/DCCKnockDown")); 
       
        f = new Replicate();
        select = new Selection((Class<EncodeObject>)f.getClass());
        select.saveToDirectory(new java.io.File("/nfs/waterston/DCCKnockDown")); 
         */
        int iusadfhiu = 0;
    }
}
