/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.objects;

import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonObject;
import org.rhwlab.encode.RNASeq.LocalLibrary;
import org.rhwlab.encode.RNASeq.LocalReplicate;

/**
 *
 * @author gevirl
 */
public class Replicate extends EncodeObject {
    public Replicate(){
        super();
    }
    public Replicate(JsonObject o){
        this();
        this.jsonObj = o;
    }
    public String getSelectionUrl() {
         return "https://www.encodeproject.org/search/?type=Replicate&library.award=%2Fawards%2FU41HG007355%2F&library.lab=%2Flabs%2Frobert-waterston%2F&limit=all&format=json";
    }

    @Override
    public TreeMap<String, Object> asMap() {
        TreeMap<String,Object> map = new TreeMap<>();
        
        map.putAll(new Experiment(jsonObj.getJsonObject("experiment")).asMap());
        map.putAll(new Library(jsonObj.getJsonObject("library")).asMap());
        map.put("ReplicateBio", Integer.toString(jsonObj.getInt("biological_replicate_number")));
        map.put("ReplicateTech", Integer.toString(jsonObj.getInt("technical_replicate_number")));
        map.put("ReplicateUUID",jsonObj.getString("uuid"));
        String alias = this.getWaterstonAlias();
        map.put("ReplicateAlias",alias);
        try {
            LocalReplicate local = new LocalReplicate(alias);
            map.putAll(local.getSummary());
        } catch (Exception ex) {
            Logger.getLogger(Biosample.class.getName()).log(Level.SEVERE, null, ex);
        }         
        return map;
    }
    @Override
    public void expand() {

    }

}
