/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.objects;

import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.rhwlab.encode.RNASeq.LocalBiosample;
import org.rhwlab.encode.RNASeq.LocalLibrary;

/**
 *
 * @author gevirl
 */
public class Library extends EncodeObject {
    public Library(){
        super();
    }
    public Library(JsonObject o){
        this();
        this.jsonObj = o;
    }
    @Override
    public String getSelectionUrl() {
        return "https://www.encodeproject.org/search/?type=Library&award=%2Fawards%2FU41HG007355%2F&submitted_by=%2Fusers%2F8cab8958-22c9-4b27-ba37-7696e8b604c4%2F&limit=all&format=json";
    }

    @Override
    public TreeMap<String, Object> asMap() {
        if (jsonObj.getString("accession").equals("ENCLB253JEF")){
            int sdfhiusd=0;
        }
        TreeMap<String,Object> map = new TreeMap<>();
        String alias = this.getWaterstonAlias();
        map.put("LibraryStatus", jsonObj.getString("status"));
        map.put("LibraryDocuments", Integer.toString(jsonObj.getJsonArray("documents").size()));
        map.put("LibraryAlias",alias);
        map.put("LibraryAccession", jsonObj.getString("accession"));
        JsonValue biosample = jsonObj.get("biosample");
        if (biosample instanceof JsonObject){
            map.putAll(new Biosample(jsonObj.getJsonObject("biosample")).asMap());
        } else if (biosample instanceof JsonString ){
/*            
            try {
                JsonObject obj = getFromEncode(((JsonString)biosample).getString());
                map.putAll(new Biosample(obj).asMap());
            } catch (Exception exc){
                exc.printStackTrace();
            }
 */           
            map.put("BiosampleAccession",((JsonString) biosample).getString().split("/")[2]);
        }
        try {
            LocalLibrary local = new LocalLibrary(alias);
            map.putAll(local.getSummary());
        } catch (Exception ex) {
            Logger.getLogger(Biosample.class.getName()).log(Level.SEVERE, null, ex);
        }        
        return map;
    }
    @Override
    public void expand() {

    }    
}
