/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.objects;

import java.util.TreeMap;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import org.rhwlab.encode.RNASeq.LocalSequencing;

/**
 *
 * @author gevirl
 */
public class File extends EncodeObject {
    public File(){
        super();
    }
    public File(JsonObject o){
        this();
        this.jsonObj = o;
    }

    @Override
    public String getSelectionUrl() {
        return "https://www.encodeproject.org/search/?type=File&award.project=modERN&lab.title=Robert+Waterston%2C+UW&limit=all&format=json";        
    }

    @Override
    public TreeMap<String, Object> asMap() {
        TreeMap<String,Object> map = new TreeMap<>();
            JsonObject rep = jsonObj.getJsonObject("replicate");
            if (rep != null){
                 
                map.put("SubmittedFile", jsonObj.getString("submitted_file_name"));
                map.put("FileStatus", jsonObj.getString("status"));
                JsonString acc = jsonObj.getJsonString("accession");
                if (acc != null){
                    map.put("FileAccession", jsonObj.getString("accession"));
                } else {
                    map.put("FileAccession","");
                }
                map.put("Format",jsonObj.getString("file_format") );
                map.put("MD5", jsonObj.getString("md5sum"));
                
                String alias = this.getWaterstonAlias();
                if (alias != null ){
                    map.put("FileAlias",alias); 
                    try {
                        
                        LocalSequencing localSeq = new LocalSequencing(alias);
                        TreeMap<String,String> localMap = localSeq.getSummary();
                        map.putAll(localMap);
                        if (localMap.get("LocalFileAccession").equals(map.get("FileAccession"))){
                            map.put("LocalAccessionMatches", "matched");
                        } else {
                            map.put("LocalAccessionMatches", "not-matched");
                        }
                        if (localMap.get("LocalFileMD5").equals(map.get("MD5"))){
                            map.put("LocalMD5Matches", "matched");
                        } else {
                            map.put("LocalMD5Matches", "not-matched");
                        }                        
                    } catch (Exception exc){
                        exc.printStackTrace();
                    }
                }else {
                    map.put("FileAlias", "");
                }
                map.putAll(new Replicate(rep).asMap());
                JsonObject audit = jsonObj.getJsonObject("audit");
                if (audit != null){
                    map.putAll(new Audit(audit,"File").asMap());
                }      
                int iuasdfuihs=0;
            }

        return map;
    }
    @Override
    public void expand() {

    }    
}
