/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.objects;

import java.util.TreeMap;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

/**
 *
 * @author gevirl
 */
public class Experiment extends EncodeObject  {
    public Experiment(){
        super();
    }
    public Experiment(JsonObject o){
        this();
        this.jsonObj = o;
    }
    @Override
    public String getSelectionUrl() {
        return "https://www.encodeproject.org/search/?type=Experiment&award.project=modERN&assay_title=total+RNA-seq&assay_title=polyA+depleted+RNA-seq&assay_title=RNA-seq&limit=all&format=json";        
    }

    @Override
    public TreeMap<String, Object> asMap() {
        TreeMap<String,Object> map = new TreeMap<>();
      
        JsonValue target = jsonObj.get("target");
        if (target instanceof JsonObject){
            map.put("ExperimentTarget", ((JsonObject)target).getString("name"));
        }else if (target instanceof JsonString) {
            map.put("ExperimentTarget",((JsonString)target).getString());
        }else {
            map.put("ExperimentTarget","");
        }
        String alias = this.getWaterstonAlias();
        map.put("ExperimentAlias",alias);
        map.put("ExperimentReplicates",Integer.toString(jsonObj.getJsonArray("replicates").size()));
        map.put("ExperimentFiles",Integer.toString(jsonObj.getJsonArray("files").size()));
        map.put("ExperimentAccession",jsonObj.getString("accession"));
        map.put("ExperimentStatus",jsonObj.getString("status"));
        map.put("ExperimentAssayTitle",jsonObj.getString("assay_title"));
        map.put("ExperimentAssayName",jsonObj.getString("assay_term_name"));
        map.put("ExperimentDocuments", Integer.toString(jsonObj.getJsonArray("documents").size()));
        
        JsonObject audit = jsonObj.getJsonObject("audit");
        if (audit != null){
            map.putAll(new Audit(audit,"Experiment").asMap());
        }

        return map;
    }
    
    // returns the WBGene id for worms or the FBgn for fly 
    public String getDbxref(){
        String ret = null;
        JsonObject target = this.jsonObj.getJsonObject("target");
        if (target != null){
            JsonArray xrefs = target.getJsonArray("dbxref");
            if (xrefs != null){
                for (int i=0 ; i<xrefs.size() ; ++i){
                    String[] tokens = xrefs.getString(i).split(":");
                    if (tokens[0].equals("WormBase")){
                        if (tokens[1].startsWith("WBGene")){
                            ret = tokens[1];
                        }
                    } else if (tokens[0].equals("FlyBase")){
                        if (tokens[1].startsWith("FBgn")){
                            ret = tokens[1];
                        }
                    }
                }
            }
        }
        return ret;
    }
  
    public String getGeneName(){
        String ret = null;
        JsonObject target = this.jsonObj.getJsonObject("target");
        if (target != null){
            JsonString gene = target.getJsonString("gene_name");
            if (gene != null){
                ret = gene.getString();
            }
        } 
        return ret;
    }
    @Override
    public void expand() {

    }    
}
