/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.rhwlab.encode.EncodeUrl;

/**
 *
 * @author gevirl
 */
abstract public class EncodeObject {
    JsonObject jsonObj;
    
    abstract public String getSelectionUrl();
    abstract public void expand();
    
    public void setJsonObject(JsonObject obj){
        jsonObj = obj;
    }
    public JsonObject getJsonObject(){
        return jsonObj;
    }
    
    // expand an entry in the json defined by the list of identifiers
    static public JsonStructure expand(JsonValue obj,List<String> keys)throws Exception {
        
        if (obj instanceof JsonArray){
            JsonArray jsonArray = (JsonArray)obj;
            JsonArrayBuilder builder = Json.createArrayBuilder();
            for (int i=0 ; i<jsonArray.size() ; ++i){
                JsonStructure jsonStruct = expand(jsonArray.get(i),keys);
                builder.add(jsonStruct);
            }
            return builder.build();
        } 
        else if (obj instanceof JsonObject){
            JsonObject jsonObj = (JsonObject)obj;
            if (!keys.isEmpty()){
                String toExpandKey = keys.get(0);
                JsonValue jsonValue = jsonObj.get(toExpandKey);
                ArrayList<String> nextKeys = new ArrayList<>();
                nextKeys.addAll(keys);
                nextKeys.remove(0);
                JsonStructure jsonStruct =  expand(jsonValue,nextKeys);
                
                // rebuild the input json object
                JsonObjectBuilder builder = Json.createObjectBuilder();
                for (String key : jsonObj.keySet()){
                    if (key.equals(toExpandKey)){
                        builder.add(key,jsonStruct);
                    }else {
                        builder.add(key,jsonObj.get(key));
                    }
                }  
                return builder.build();
            } else {
                JsonString jsonString = (JsonString)jsonObj.get("@id");
                return getFromEncode(jsonString.getString());
            }

        } 
        else if (obj instanceof JsonString){
            // the string must be an encode id
            return  getFromEncode(((JsonString)obj).getString());
        }
        else {
            return null;
        }
    }

    public void expand(String expand)throws Exception{
        JsonValue toExpand = jsonObj.get(expand);
        if (toExpand instanceof JsonArray){
            JsonArray expandArray = (JsonArray)toExpand;
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (int i=0 ; i<expandArray.size() ; ++i){

                JsonValue arrayValue = expandArray.get(i);
                if (arrayValue instanceof JsonString ){
                    JsonObject replacement = getFromEncode(((JsonString) arrayValue).getString());
                    arrayBuilder.add(replacement);
                }
            }
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            for (String key : jsonObj.keySet()){
                if (key.equals(expand)){
                    objectBuilder.add(expand,arrayBuilder.build() );
                } else {
                    objectBuilder.add(key, jsonObj.get(key));
                }
            }
            this.jsonObj = objectBuilder.build();
            int asidfisd=0;
        } else if (toExpand instanceof JsonString){
            JsonObject replacement = getFromEncode(((JsonString) toExpand).getString());
            jsonObj.put(expand, replacement);
        } else if ( toExpand instanceof JsonObject){
           JsonObject replacement = getFromEncode( ((JsonObject) toExpand).getJsonString("@id").getString());
           jsonObj.put(expand, replacement);
        }
    }

    
    static public JsonObject getFromEncode(String id)throws Exception {
        EncodeUrl url = new EncodeUrl(String.format("https://www.encodeproject.org%s",id));
        url.getJson();
        return url.getJsonObject();  

    }
    public String getWaterstonAlias(){
        TreeMap<Integer,String> aliasMap = new TreeMap<>();
        
        JsonArray aliases = jsonObj.getJsonArray("aliases");
        for (int i=0 ; i<aliases.size() ; ++i){
            String alias = aliases.getJsonString(i).getString();
            if (alias.startsWith("robert-waterston:")){
                String a = alias.replace("robert-waterston:", "");
                String[] tokens = a.split("_");
                aliasMap.put(tokens.length,a);
            }
        }
        if (aliasMap.lastEntry() == null){
            return null;
        }
        return aliasMap.lastEntry().getValue();
    }
    abstract public TreeMap<String,Object> asMap();

}
