/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.objects;

import java.util.TreeMap;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;

/**
 *
 * @author gevirl
 */
public class Donor extends EncodeObject  {
    public Donor(){
        super();
    }
    public Donor(JsonObject o){
        this();
        this.jsonObj = o;
    }
    @Override
    public String getSelectionUrl() {
        return "https://www.encodeproject.org/search/?type=Donor&award=%2Fawards%2FU41HG007355%2F&limit=all&format=json";

    }

    @Override
    public TreeMap<String, Object> asMap() {
        TreeMap<String,Object> map = new TreeMap<>();
        JsonArray genMods = jsonObj.getJsonArray("genetic_modifications");

        map.put("DonorAccession",jsonObj.getString("accession"));
        JsonString genotype = jsonObj.getJsonString("genotype");
        if (genotype != null){
            map.put("DonorGenotype", genotype.toString());
        } else {
            map.put("DonorGenotype", "");
        }
        JsonString strain = jsonObj.getJsonString("strain_name");
        if (strain != null){
            map.put("DonorStrain",strain.getString());
        } else {
            map.put("DonorStrain","");
        }
        map.put("DonorStatus",jsonObj.getString("status"));
        
        map.put("DonorGeneMods", Integer.toString(genMods.size()));
        if (!genMods.isEmpty()){
            if (genMods.get(0) instanceof JsonObject){
                map.putAll(new Modification(genMods.getJsonObject(0)).asMap());
            }else {
                
/*               
                try {
                    map.putAll(new Modification(getFromEncode(genMods.getString(0))).asMap());
                } catch (Exception exc){
                    exc.printStackTrace();
                }
*/
               
            }
            
        } else {
//            map.putAll(new Modification().asMap());
        }
        
        return map;
    }
    @Override
    public void expand() {

    }    
}
