/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.objects;

import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.rhwlab.encode.RNASeq.LocalBiosample;

/**
 *
 * @author gevirl
 */
public class Biosample extends EncodeObject {
    public Biosample(){
        super();
    }
    public Biosample(JsonObject o){
        this();
        this.jsonObj = o;
    }
    @Override
    public String getSelectionUrl() {
        return "https://www.encodeproject.org/search/?type=Biosample&award.project=modERN&limit=all&format=json";
    }

    @Override
    public TreeMap<String, Object> asMap() {
        TreeMap<String,Object> map = new TreeMap<>();
        JsonArray aliases = jsonObj.getJsonArray("aliases");
        if (aliases.size() == 0) return map;
        
        for (int i= 0 ; i<aliases.size() ; ++i){
            String alias = aliases.getString(i);
            if (alias.contains("robert-waterston:biosample")){
                map.put("BiosampleAlias",alias.replace("robert-waterston:", ""));
                map.putAll(new Donor(jsonObj.getJsonObject("donor")).asMap());
                map.put("BiosampleStatus",jsonObj.getString("status"));
                map.put("BiosampleAccession",jsonObj.getString("accession")); 
                JsonObject audit = jsonObj.getJsonObject("audit");
                if (audit != null){
                    map.putAll(new Audit(audit,"Biosample").asMap());
                }   
                
                try {
                    LocalBiosample local = new LocalBiosample(alias);
                    map.putAll(local.getSummary());
                } catch (Exception ex) {
                    Logger.getLogger(Biosample.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
        }
        

        return map;
    }
    @Override
    public void expand() {

    }    
}
