/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.download;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 *
 * @author gevirl
 */
public class ZipThread implements Runnable {
    public ZipThread(Map<String,URL> urls)throws Exception {
        this.urls = urls;
        pipeStream = new PipedOutputStream();
        zipOut = new ZipOutputStream(pipeStream);
        pipeIn = new PipedInputStream(pipeStream);        
    }    
    @Override
    public void run() {
        try {
            for (String urlName : urls.keySet()) {
                addUrl(urlName,urls.get(urlName));
            }
            zipOut.close();  
        } catch (Exception exc)        {
            exc.printStackTrace();
        }
    }
    private void addUrl(String urlName,URL url)throws Exception {
        byte[] data = new byte[BUFFER];
        System.out.printf("%s\t%s\n",urlName,url.toExternalForm());
        BufferedInputStream inStream = new BufferedInputStream(url.openStream());
        ZipEntry entry = new ZipEntry(urlName);
        zipOut.putNextEntry(entry);    
        int n;
        n=inStream.read(data, 0, BUFFER);
        zipOut.write(data, 0, n);
        while (n !=-1){
            n=inStream.read(data, 0, BUFFER);
            if (n > 0) zipOut.write(data, 0, n);
        }
        inStream.close();      
        
    }    
    public InputStream getStream(){
        return pipeIn;
    }
    // write the zip file in a new thread
    public void writeTo(File file){
        Runnable runnable = new Runnable() {
            @Override
            public void run() {
                byte[] bytes = new byte[1000];
                try {
                    FileOutputStream outStream = new FileOutputStream(file);
                    while (true){
                        int bytesRead = pipeIn.read(bytes,0,1000);
                        if (bytesRead == -1){
                            outStream.close();
                            return;
                        }
                        outStream.write(bytes,0, bytesRead);
                    }                    
                } catch (Exception exc){
                    exc.printStackTrace();
                    return;
                }
            }
        };
        new Thread(runnable).start();
    }
    Map<String,URL> urls;
    PipedOutputStream pipeStream;
    PipedInputStream pipeIn;
    ZipOutputStream zipOut; 
    
    static final int BUFFER = 2048;    
}
