/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.RNASeq;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import org.rhwlab.encode.objects.Replicate;
import org.rhwlab.encode.objects.EncodeObject;
import org.rhwlab.encode.objects.Selection;
import org.rhwlab.encode.objects.Experiment;
import org.rhwlab.encode.objects.File;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import org.rhwlab.encode.objects.Biosample;
import org.rhwlab.encode.objects.FlyDonor;
import org.rhwlab.encode.objects.Library;
import org.rhwlab.encode.objects.WormDonor;

/**
 *
 * @author gevirl
 */
public class SummaryFrame extends JFrame{
    JTabbedPane tabbed;
    java.io.File dir = new java.io.File("/nfs/waterston/DCCKnockDown");
    TreeMap<String,JTable> tableMap = new TreeMap<>();
    
    public SummaryFrame(Set<String> tabs)throws Exception {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem saveSel = new JMenuItem("Save selected");
        saveSel.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                if (chooser.showSaveDialog(tabbed) == JFileChooser.APPROVE_OPTION){
                    try {
                        PrintStream stream = new PrintStream(chooser.getSelectedFile());
                        saveSelected(stream);
                    } catch (FileNotFoundException ex) {
                        Logger.getLogger(SummaryFrame.class.getName()).log(Level.SEVERE, null, ex);
                    }
                
                }
            }
        });
        fileMenu.add(saveSel);
        
        JMenu update = new JMenu("Update from DCC");
        fileMenu.add(update);
        
        JMenuItem expItem = new JMenuItem("Experiments");
        expItem.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EncodeObject f = new Experiment();
                    Selection select = new Selection((Class<EncodeObject>)f.getClass());
                    select.saveToDirectory(dir);
                    replaceTab("Experiments",select.toTable());
                } catch (Exception ex) {
                    Logger.getLogger(SummaryFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        
        JMenuItem filesItem = new JMenuItem("Files");
        filesItem.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EncodeObject f = new File();
                    Selection select = new Selection((Class<EncodeObject>)f.getClass());
                    select.saveToDirectory(dir);
                    replaceTab("Files",select.toTable());
                } catch (Exception ex) {
                    Logger.getLogger(SummaryFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });  
        
        JMenuItem repsItem = new JMenuItem("Replicates");
        repsItem.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EncodeObject f = new Replicate();
                    Selection select = new Selection((Class<EncodeObject>)f.getClass());
                    select.saveToDirectory(dir);
                    replaceTab("Replicates",select.toTable());
                } catch (Exception ex) {
                    Logger.getLogger(SummaryFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });          
        
        JMenuItem libItem = new JMenuItem("Libraries");
        libItem.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EncodeObject f = new Library();
                    Selection select = new Selection((Class<EncodeObject>)f.getClass());
                    select.saveToDirectory(dir);
                    replaceTab("Libraries",select.toTable());
                } catch (Exception ex) {
                    Logger.getLogger(SummaryFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });    
        
        JMenuItem sampItem = new JMenuItem("Biosamples");
        sampItem.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EncodeObject f = new Biosample();
                    Selection select = new Selection((Class<EncodeObject>)f.getClass());
                    select.saveToDirectory(dir);
                    replaceTab("Biosamples",select.toTable());
                } catch (Exception ex) {
                    Logger.getLogger(SummaryFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });  
        
        JMenuItem flydonorItem = new JMenuItem("FlyDonors");
        flydonorItem.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EncodeObject f = new FlyDonor();
                    Selection select = new Selection((Class<EncodeObject>)f.getClass());
                    select.saveToDirectory(dir);
                    replaceTab("FlyDonors",select.toTable());
                } catch (Exception ex) {
                    Logger.getLogger(SummaryFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }); 
        
        JMenuItem wormdonorItem = new JMenuItem("WormDonors");
        wormdonorItem.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EncodeObject f = new WormDonor();
                    Selection select = new Selection((Class<EncodeObject>)f.getClass());
                    select.saveToDirectory(dir);
                    replaceTab("WormDonors",select.toTable());
                } catch (Exception ex) {
                    Logger.getLogger(SummaryFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });         
        
        update.add(expItem);
        update.add(filesItem);
        update.add(repsItem);
        update.add(libItem);
        update.add(sampItem);
        update.add(flydonorItem);
        update.add(wormdonorItem);
        
        
        menuBar.add(fileMenu);
        this.setJMenuBar(menuBar);
        
        EncodeObject fl = new File();
        EncodeObject rep = new Replicate();
        EncodeObject flydonor = new FlyDonor();
        EncodeObject wormdonor = new WormDonor();
        EncodeObject exp = new Experiment();
        EncodeObject lib = new Library();
        EncodeObject samp = new Biosample();
        
        tabbed = new JTabbedPane();

        
        
        if (tabs.contains("Experiments")){
            String key = "experiments";
            Selection sel = new Selection(new java.io.File(dir,key),(Class<EncodeObject>)exp.getClass());
            tabbed.add(key,sel.toTable());
            tableMap.put(key,sel.getTable());
        }
        if (tabs.contains("Files")){
            String key = "files";
            Selection sel = new Selection(new java.io.File(dir,key),(Class<EncodeObject>)fl.getClass());
            tabbed.add(key,sel.toTable());
            tableMap.put(key,sel.getTable());            
        }
        if (tabs.contains("Replicates")){
            String key = "replicates";
            Selection sel = new Selection(new java.io.File(dir, "replicates"), (Class<EncodeObject>) rep.getClass());
            tabbed.add(key,sel.toTable());
            tableMap.put(key,sel.getTable());            
        } 
        if (tabs.contains("Libraries")){
            String key = "libraries";
            Selection sel = new Selection(new java.io.File(dir, "libraries"), (Class<EncodeObject>) lib.getClass());
            tabbed.add(key,sel.toTable());
            tableMap.put(key,sel.getTable()); 
        }       
        if (tabs.contains("Biosamples")){
            String key = "biosamples";
            Selection sel = new Selection(new java.io.File(dir, "biosamples"), (Class<EncodeObject>) samp.getClass());
            tabbed.add(key,sel.toTable());
            tableMap.put(key,sel.getTable());
        }        
        if (tabs.contains("FlyDonors")){
            String key = "fly-donors";
            Selection sel = new Selection(new java.io.File(dir, "fly-donors"), (Class<EncodeObject>) flydonor.getClass());
            tabbed.add(key,sel.toTable());
            tableMap.put(key,sel.getTable());
        }
        if (tabs.contains("WormDonors")){
            String key = "worm-donors";
            Selection sel = new Selection(new java.io.File(dir, "worm-donors"), (Class<EncodeObject>) wormdonor.getClass());
            tabbed.add(key, sel.toTable());
            tableMap.put(key, sel.getTable());
        }        
        this.getContentPane().add(tabbed);
        pack();
    }
    private void replaceTab(String title,Component c){
        int n = tabbed.getTabCount();
        for (int i=0 ; i<n ; ++n){
            String tab = tabbed.getTitleAt(i);
            if (tab.equals(title)){
                tabbed.setComponentAt(i, c);
            }
        }
    }
    
    private void saveSelected(PrintStream stream){
        String tab = tabbed.getTitleAt(tabbed.getSelectedIndex());
        JTable selectedTable = tableMap.get(tab);
       
        int[] rows = selectedTable.getSelectedRows();
        int nCols = selectedTable.getColumnCount();
        for (int i= 0 ; i<nCols ; ++i){
            stream.printf("%s\t",selectedTable.getColumnName(i));
        }
        stream.println();
        for (int i=0 ; i<rows.length ; ++i){
            int r = rows[i];
            for (int c=0 ; c<selectedTable.getColumnCount() ; ++c){
                Object obj = selectedTable.getValueAt(r, c);
                stream.printf("%s\t", obj.toString());
            }
            stream.println();
        }
    }
    static public void main(String[] args)throws Exception {
        LinkedHashSet set = new LinkedHashSet<>();
        for (int i=0 ; i<args.length ; ++i){
            set.add(args[i]);
        }
        SummaryFrame frame = new SummaryFrame(set);
        
        frame.setSize(900,900);
        frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        frame.setVisible(true);
    }
}
