/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.RNASeq;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.rhwlab.encode.EncodeUrl;

/**
 *
 * @author gevirl
 */
public class Sample {
    JsonObject json;
    
    public Sample(JsonObject obj){
        json = obj;
    }
    public Sample(String accession)throws Exception {
        EncodeUrl url = new EncodeUrl(String.format("https://www.encodeproject.org/biosamples/%s/?format=json", accession));
        url.getJson();
        json = url.getJsonObject(); 

        
    }
    public JsonObject getJsonObject(){
        return this.json;
    }
    public TreeMap<String,String> getSummary(){
        TreeMap<String,String> ret = new TreeMap<>();
        ret.put("SampleAlias",json.getJsonArray("aliases").getJsonString(0).getString().replace("robert-waterston:",""));
        ret.put("SampleAccession", json.getString("accession"));
        ret.put("DonorAccession", json.getJsonObject("donor").getString("accession"));
        ret.put("DonorStrain", json.getJsonObject("donor").getString("strain_name"));
        if (json.getJsonObject("donor").getJsonString("genotype")!=null){
            ret.put("DonorGenotype", json.getJsonObject("donor").getString("genotype"));
        }
        ret.put("Species", getSpecies());

        JsonArray genMods = json.getJsonArray("applied_modifications");
        if (genMods != null){
            for (int i=0 ; i<genMods.size() ; ++i){
                JsonObject mod = genMods.getJsonObject(i);
                JsonObject site = mod.getJsonObject("modified_site_by_target_id");
                if (site != null){
                    ret.put("GeneticModificationTarget",site.getString("name"));
                }
            }
        }
        return ret;
    }
    public String getSpecies(){
        return json.getJsonObject("organism").getString("name");
    }
    
    static public List<Sample> allBioSamples(){
        ArrayList<Sample> ret = new ArrayList<>();
        return ret;
    }
    static String searchUrl =
            "https://www.encodeproject.org/search/?type=File&award.project=modERN&lab.title=Robert+Waterston%2C+UW&limit=all&format=json";    
}
