/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.RNASeq;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import org.rhwlab.json.PrettyWriter;

/**
 *
 * @author gevirl
 */
public class ResponseJsonDCC {
    ArrayList<PrettyWriter> prettyList = new ArrayList<>(); 
    
    public ResponseJsonDCC(String s){
        
        BufferedReader bufReader = new BufferedReader(new StringReader(s));
        try {
            String line = bufReader.readLine();
            while (line != null){
                PrettyWriter pretty = new PrettyWriter();
                pretty.write(line);
                prettyList.add(pretty);
                line = bufReader.readLine();
            }
            bufReader.close();
        } catch (Exception exc){
            exc.printStackTrace();
        }
      
    }
    public Map<String,String> getIdentifiersDCC(){
        HashMap<String,String> ret = new HashMap<>();

        for (PrettyWriter pretty : prettyList){
            JsonArray graphArray = pretty.getJson().getJsonArray("@graph");
            for (int i=0 ; i<graphArray.size() ; ++i){
                JsonObject respObject = graphArray.getJsonObject(i);
                JsonArray typeArray = respObject.getJsonArray("@type");
                for (int j=0 ; j<typeArray.size() ; ++j){
                    String type = typeArray.getJsonString(j).getString().toLowerCase();
                    JsonString jsonAcc = respObject.getJsonString("accession");
                    if (jsonAcc != null){
                        ret.put(type.toLowerCase(),jsonAcc.getString());
                    } else {
                        ret.put(type.toLowerCase(),respObject.getJsonString("uuid").getString());
                    }

                }
            }
        }
        return ret;         
    }
    public Map<String,String> getFileAccessions(){
        HashMap<String,String> ret = new HashMap<>();

        for (PrettyWriter pretty : prettyList){
            String acc = getAccession("file",pretty);
            if (!acc.equals("")){
                String n = getPairedEnd(pretty);
                if (n != null){
                    ret.put(n, acc);
                }
            }
        }
        return ret;        
    }    
    public String getAccession(String jsonType,PrettyWriter pretty){
        JsonArray graphArray = pretty.getJson().getJsonArray("@graph");
        for (int i=0 ; i<graphArray.size() ; ++i){
            JsonObject respObject = graphArray.getJsonObject(i);
            JsonArray typeArray = respObject.getJsonArray("@type");
            for (int j=0 ; j<typeArray.size() ; ++j){
                String type = typeArray.getJsonString(j).getString().toLowerCase();
                if (type.equalsIgnoreCase(jsonType)){
                    JsonString jsonString = respObject.getJsonString("accession");
                    if (jsonString==null){
                        return "";
                    }
                    return jsonString.getString();
                }
            }
        }
        return "";

    }   
    public Map<String,String> getMD5(){
        HashMap<String,String> ret = new HashMap<>();

        for (PrettyWriter pretty : prettyList){
            String md5 = getMD5("file",pretty);
            if (!md5.equals("")){
                String n = getPairedEnd(pretty);
                if (n != null){
                    ret.put(n, md5);
                }
            }
        }
        return ret;         
    }
    public String getMD5(String jsonType,PrettyWriter pretty){
        JsonArray graphArray = pretty.getJson().getJsonArray("@graph");
        for (int i=0 ; i<graphArray.size() ; ++i){
            JsonObject respObject = graphArray.getJsonObject(i);
            JsonArray typeArray = respObject.getJsonArray("@type");
            for (int j=0 ; j<typeArray.size() ; ++j){
                String type = typeArray.getJsonString(j).getString().toLowerCase();
                if (type.equalsIgnoreCase(jsonType)){
                    JsonString jsonString = respObject.getJsonString("md5sum");
                    if (jsonString==null){
                        return "";
                    }
                    return jsonString.getString();
                }
            }
        }
        return "";

    }      
    public String getPairedEnd(PrettyWriter pretty){
        JsonArray graphArray = pretty.getJson().getJsonArray("@graph");
        for (int i=0 ; i<graphArray.size() ; ++i){
            JsonObject respObject = graphArray.getJsonObject(i);
            JsonArray typeArray = respObject.getJsonArray("@type");
            for (int j=0 ; j<typeArray.size() ; ++j){
                String type = typeArray.getJsonString(j).getString().toLowerCase();
                if (type.equalsIgnoreCase("file")){
                    return respObject.getJsonString("paired_end").getString();
                }
            }
        }
        return null;
    } 
}
