/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.RNASeq;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.TreeMap;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class LocalSequencing {
    String seqID;
    String pair;
    String resp;
    String status;
            
    public LocalSequencing(String aliasDCC)throws Exception {
        int i = aliasDCC.indexOf("_");
        String prefix = aliasDCC.substring(0, i);
        seqID = aliasDCC.substring(i+1);
        seqID = seqID.replace("BS1", "BS#1");
        seqID = seqID.replace("BS2", "BS#2");
        if (prefix.startsWith("fastq")){
            pair = prefix.substring(5);
            
            PreparedStatement state = MySql.getMySql().getStatement("select * from RNASequencing where SequencingID = ?");
            state.setString(1, seqID);
            state.execute();
            ResultSet rs = state.getResultSet();
            if (rs.next()){
                resp = rs.getString("ResponseJson");
                
                state = MySql.getMySql().getStatement("select * from LMSTracking where ID = ? and DBTable = ? and Project = ?");
                state.setString(1, seqID);
                state.setString(2, "RNASequencing");
                state.setString(3, "KnockDown");
                state.execute();
                rs = state.getResultSet();
                if (rs.next()){
                    status = rs.getString("Status");
                }
            }
        }
    }

  
    public TreeMap<String,String> getSummary(){
        TreeMap<String,String> ret = new TreeMap<>();
        if (status != null){
            ret.put("LocalSequencingStatus",status);
        }else {
            ret.put("LocalSequencingStatus","");
        }
        
        if (resp == null){
            ret.put("LocalFileAccession","");
            ret.put("LocalFileMD5","");
        } else {
            ResponseJsonDCC dcc = new ResponseJsonDCC(resp);
            Map<String,String> accs = dcc.getFileAccessions();
            Map<String,String> md5s = dcc.getMD5();
            ret.put("LocalFileAccession",accs.get(pair) );
            ret.put("LocalFileMD5",md5s.get(pair) );
        }
        return ret;
    }

}
