/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.RNASeq;

import java.util.Map;
import java.util.TreeMap;

/**
 *
 * @author gevirl
 */
public class LocalFile extends Local {
    public LocalFile(String fileAlias)throws Exception {
        super(fileAlias,"","");
    }
    @Override
    public TreeMap<String, String> getSummary() {
        TreeMap<String,String> ret = new TreeMap<>();
        if (status != null){
            ret.put("LocalSequencingStatus",status);
        }else {
            ret.put("LocalSequencingStatus","");
        }
        
        if (resp == null){
            ret.put("LocalSequencingAccession","");
            ret.put("LocalSequencingMD5","");
        } else {
            String pair = prefix.substring(5);
            ResponseJsonDCC dcc = new ResponseJsonDCC(resp);
            Map<String,String> accs = dcc.getFileAccessions();
            Map<String,String> md5s = dcc.getMD5();
            ret.put("LocalSequencingAccession",accs.get(pair) );
            ret.put("LocalSequencingMD5",md5s.get(pair) );
        }
        return ret;
    
    }
    
}
