/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.RNASeq;

import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import org.rhwlab.encode.EncodeUrl;

/**
 *
 * @author gevirl
 */
public class EncodeFile {
    JsonObject fileJson;
    Sample biosample;
    LocalSequencing localSeq;
    public EncodeFile(JsonObject json)throws Exception {
        this.fileJson = json.getJsonObject("file");
        JsonObject samObj = json.getJsonObject("sample");
        if (samObj != null){
            this.biosample = new Sample(samObj);
        }
        if (getFileFormat().equals("fastq")){
            localSeq = new LocalSequencing(getFileAlias());
        }
    }
    public EncodeFile(String accession) throws Exception {
        EncodeUrl url = new EncodeUrl(String.format("https://www.encodeproject.org/files/%s/?format=json", accession));
        url.getJson();
        fileJson = url.getJsonObject(); 
        String sampleAcc = this.getBiosampleAccession();
        if (sampleAcc != null){
            biosample = new Sample(sampleAcc);
        }
        if (getFileFormat().equals("fastq")){
            localSeq = new LocalSequencing(getFileAlias());
        }
    }
    public JsonObject getJsonObject(){
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("file", fileJson);
        if (biosample != null){
            builder.add("sample", biosample.getJsonObject());
        }
        return builder.build();
    }
    public TreeMap<String,String> getSummary(){
        TreeMap<String,String> ret = new TreeMap<>();
            ret.put("SubmittedFile", fileJson.getString("submitted_file_name"));
            ret.put("FileStatusDCC", fileJson.getString("status"));
            ret.put("FileAccession", fileJson.getString("accession"));
            ret.put("Format", getFileFormat() );
            ret.put("MD5", fileJson.getString("md5sum"));
            ret.put("BioReplicate", Integer.toString(fileJson.getJsonObject("replicate").getInt("biological_replicate_number")));
            ret.put("TechReplicate", Integer.toString(fileJson.getJsonObject("replicate").getInt("technical_replicate_number"))); 
            ret.put("FileAlias",getFileAlias());
            ret.put("ReplicateAlias", fileJson.getJsonObject("replicate").getJsonArray("aliases").getString(0).replace("robert-waterston:",""));
            ret.put("LibraryAlias", fileJson.getJsonObject("replicate").getJsonObject("library").getJsonArray("aliases").getString(0).replace("robert-waterston:",""));
            ret.put("LibraryAccession", fileJson.getJsonObject("replicate").getJsonObject("library").getJsonString("accession").getString());
            ret.put("ExperimentAccession", fileJson.getJsonObject("replicate").getJsonObject("experiment").getJsonString("accession").getString());
            JsonObject targetObj = fileJson.getJsonObject("replicate").getJsonObject("experiment").getJsonObject("target");
            if (targetObj != null){
                ret.put("ExperimentTarget", targetObj.getString("name"));
            } else {
                ret.put("ExperimentTarget","");
            }
            ret.putAll(biosample.getSummary());
            if (localSeq != null){
                ret.putAll(localSeq.getSummary());
            }
        return ret;
    }

    public String getFileFormat(){
        return fileJson.getString("file_format");
    }
    public String getFileAlias(){
        return fileJson.getJsonArray("aliases").getJsonString(0).getString().replace("robert-waterston:", "");
    }
    public String getBiosampleAccession(){
        return getBiosampleAccession(fileJson);
    }
    public String getBiosampleAccession(JsonObject obj){
        try {
            return obj.getJsonObject("replicate").getJsonObject("library").getJsonString("biosample").getString().split("/")[2];
        } catch(Exception exc){
            return null;
        }
    }
    public String getSpecies(){
        return biosample.getSpecies();
/*        
        try {
            JsonObject rep = fileJson.getJsonObject("replicate");
            JsonObject exp = rep.getJsonObject("experiment");
            JsonObject tar = exp.getJsonObject("target");
            JsonString org = tar.getJsonString("organism");
            String sp = org.getString();
            return sp.split("/")[2];
        } catch (Exception exc){
            return null;
        }
*/
    }
}
