/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.RNASeq;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import org.glassfish.json.JsonPrettyGeneratorImpl;
import org.rhwlab.db.MySql;
import org.rhwlab.encode.EncodeUrl;

/**
 *
 * @author gevirl
 */
public class AllEncodeFiles {

    Map<String,List<EncodeFile>> encodeFiles = new TreeMap<>();
    JsonObject biosamples;

    public AllEncodeFiles(File file) throws Exception {
        JsonReader reader = Json.createReader(new FileReader(file));
        JsonArray jsonArray = reader.readArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            EncodeFile encodeFile = new EncodeFile(jsonArray.getJsonObject(i));
            addFile(encodeFile);
        }
    }

    public AllEncodeFiles() throws Exception {
        EncodeUrl url = new EncodeUrl(searchUrl);
        url.getJson();
        JsonObject obj = url.getJsonObject();

        JsonArray fileList = obj.getJsonArray("@graph");
        for (int i = 0; i < fileList.size(); ++i) {
            JsonObject fileObj = fileList.getJsonObject(i);
            JsonString jsonAcc = fileObj.getJsonString("accession");
            if (jsonAcc != null) {
                String accession = jsonAcc.getString();
                System.out.printf("%d %s\n", i, accession);
                addFile(new EncodeFile(accession));
            } else {
                int auishdfiudsh = 0;
            }
        }
    }
    final private void addFile(EncodeFile file){
        String format = file.getFileFormat();
        List<EncodeFile> list = encodeFiles.get(format);
        if (list == null){
            list = new ArrayList<>();
            encodeFiles.put(format,list);
        }
        list.add(file);
    }

    public void saveAsJson(File outFile) throws Exception {
        FileWriter writer = new FileWriter(outFile);
        JsonPrettyGeneratorImpl gen = new JsonPrettyGeneratorImpl(writer, new BufferPoolImpl());
        gen.writeStartArray();
        for (String format : encodeFiles.keySet()){
            List<EncodeFile> files = encodeFiles.get(format);
            for (int i = 0; i < files.size(); ++i) {
                gen.write(files.get(i).getJsonObject());
            }
        }
        gen.writeEnd();
        gen.flush();
        gen.close();

    }

    public List<EncodeFile> getEncodeFiles(String format) {
        return this.encodeFiles.get(format);
    }

    public void updateMySql() throws Exception {
        String sql = "Delete from EncodeFiles";
        MySql.getMySql().execute(sql);

        PreparedStatement state = MySql.getMySql().getStatement("Insert into EncodeFiles (FileAlias) values (?)");
        for (EncodeFile eFile : encodeFiles.get("fastq")) {
            Map map = eFile.getSummary();
            state.setString(1, (String)map.get("FileAlias"));
            state.execute();
        }
        
        
        for (EncodeFile eFile : encodeFiles.get("fastq")) {
            TreeMap<String,String> map = eFile.getSummary();
            String alias = map.get("FileAlias");
            for (String key : map.keySet() ){
                if (!key.equals("FileAlias")){
                    sql = String.format("Update EncodeFiles set %s = \"%s\" where FileAlias = \"%s\"",key,map.get(key),alias);
                    MySql.getMySql().execute(sql);
                }
            }
 
        }        

    }

    static public void main(String[] args) throws Exception {
        //       AllEncodeFiles allFiles = new AllEncodeFiles();
        //       allFiles.saveAsJson(new File("/net/waterston/vol2/home/gevirl/DCCFiles.json"));

        AllEncodeFiles files = new AllEncodeFiles(new File("/net/waterston/vol2/home/gevirl/DCCFiles.json"));
        files.updateMySql();
/*        
        WormFiles wormFiles = new WormFiles(files);
        FlyFiles flyFiles = new FlyFiles(files);

        for (EncodeFile eFile : wormFiles.getFiles()) {
            Map map = eFile.getSummary();
            int iausdfiuh = 0;
        }
        for (EncodeFile eFile : flyFiles.getFiles()) {
            Map map = eFile.getSummary();
            int iausdfiuh = 0;
        }        
*/
        int iudhfiuh = 0;
    }
    static String searchUrl
            = //            "https://www.encodeproject.org/search/?type=File&award.project=modERN&file_format=fastq&lab.title=Robert+Waterston%2C+UW&limit=all&format=json";
            "https://www.encodeproject.org/search/?type=File&award.project=modERN&lab.title=Robert+Waterston%2C+UW&limit=all&format=json";
}
