/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.ChipSeq.peaks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import org.rhwlab.chipseq.ChipSeqBedRecord;
import org.rhwlab.chipseq.Peak;

/**
 *
 * @author gevirl
 */
public class PeakFile {

    Map<String, Peak[]> peakMap = new TreeMap<>();  // array of peaks indexed by chromosome, sorted by position 
    int n = 0;  // number of peaks in the file
    String tf;
    String stage = null;

    public PeakFile(File file, String tf, String stage) throws Exception {
        this(file, tf);
        this.stage = stage;
    }

    public PeakFile(File file, String tf) throws Exception {
        this.tf = tf;
        Map<String, List<Peak>> peaks = new TreeMap<>();

        GZIPInputStream gzipStream = new GZIPInputStream(new FileInputStream(file));
        BufferedReader reader = new BufferedReader(new InputStreamReader(gzipStream));
        String line = reader.readLine();
        while (line != null) {
            String[] tokens = line.split("\t");
            int s = Integer.valueOf(tokens[1]);
            int e = Integer.valueOf(tokens[2]);
            short l = (short) (e - s + 1);
            short a = Short.valueOf(tokens[9]);
            Peak peak = new Peak(tf, s, l, a);
            List<Peak> list = peaks.get(tokens[0]);
            if (list == null) {
                list = new ArrayList<>();
                peaks.put(tokens[0], list);
            }
            list.add(peak);
            ++n;
            line = reader.readLine();
        }
        reader.close();

        sortPeaks(peaks);
    }

    public PeakFile(List<ChipSeqBedRecord> recs, String tf, String stage) {
        this(recs,tf);
        this.stage = stage;
    }

    public PeakFile(List<ChipSeqBedRecord> recs, String tf) {
        this.tf = tf;
        Map<String, List<Peak>> peaks = new TreeMap<>();
        for (ChipSeqBedRecord rec : recs) {
            Peak peak = new Peak(rec);
            List<Peak> list = peaks.get(rec.getChromosome());
            if (list == null) {
                list = new ArrayList<>();
                peaks.put(rec.getChromosome(), list);
            }
            list.add(peak);
            ++n;
        }
        sortPeaks(peaks);
    }

    final private void sortPeaks(Map<String, List<Peak>> peaks) {

        for (String chr : peaks.keySet()) {
            List<Peak> list = peaks.get(chr);
            Peak[] peakArray = list.toArray(new Peak[0]);
            Arrays.sort(peakArray);
            peakMap.put(chr, peakArray);
        }
    }

    public Peak[] getChromosomePeaks(String chromo) {
        return this.peakMap.get(chromo);
    }

    public int getRecordCount() {
        return n;
    }

    public String getTF() {
        return this.tf;
    }

    public Set<String> getChromosomes() {
        return this.peakMap.keySet();
    }

    static public void main(String[] args) throws Exception {
        PeakFile peakFile = new PeakFile(new File(
                "/net/waterston/vol2/home/gevirl/Downloads/worm/ce11/ENCFF998SQM_spp.optimal.ZTF-11_OP236_WA_Em_IP_Rep0.tagAlign_VS_ZTF-11_OP236_WA_Em_Input_Rep0.tagAlign.regionPeak.gz"), "ZTF-11");
    }

}
