/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.ChipSeq.peaks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.rhwlab.chipseq.PeakCluster;
import org.rhwlab.tfs.AllTFs;

/**
 *
 * @author gevirl
 */
public class ClusterReportFile {

    File tsv;
    List<PeakCluster> clusters;
    
    public ClusterReportFile(File tsv) throws Exception {
        this(tsv,Integer.MAX_VALUE,null);
    }
    public ClusterReportFile(File tsv,AllTFs all) throws Exception {
        this(tsv,Integer.MAX_VALUE,all);
    }    
    public ClusterReportFile(File tsv,int max,AllTFs all) throws Exception {
        this.tsv = tsv;
        clusters = new ArrayList<>();
        BufferedReader reader = new BufferedReader(new FileReader(tsv));
        String[] heads = reader.readLine().split("\t");
        String line = reader.readLine();
        while (line != null) {
            PeakCluster cluster = new PeakCluster(heads, line.split("\t"),all);
            if (cluster.getTFs().size() <= max) {
                clusters.add(cluster);
            }
            line = reader.readLine();
        }
        reader.close();        
    }
    // gets all the peaks indexed by position (chromo,meanpos) in a given size range
    public TreeMap<String,TreeMap<Integer,PeakCluster>> peaksByPosition(int min,int max){
        TreeMap<String,TreeMap<Integer,PeakCluster>> ret = new TreeMap<>();
        for (PeakCluster cluster : clusters){
            int n = cluster.getTFs().size();
            if (min<=n && n<=max){
                TreeMap<Integer,PeakCluster> chrMap = ret.get(cluster.getChromosome());
                if (chrMap == null){
                    chrMap = new TreeMap<>();
                    ret.put(cluster.getChromosome(),chrMap);
                }
                chrMap.put(n=cluster.getMeanPosition(), cluster);
            }
        }
        return ret;
    }
    // returns all the clusters indexed by target
    public TreeMap<String, List<PeakCluster>> allIndexedClusters(int min,int max) throws Exception {
        TreeMap<String, List<PeakCluster>> ret = new TreeMap<>();
        for (PeakCluster cluster : getAllPeakClusters(min,max)) {
            String target = cluster.getTarget();
            List<PeakCluster> list = ret.get(target);
            if (list == null) {
                list = new ArrayList<>();
                ret.put(target, list);
            }
            list.add(cluster);
        }
        return ret;
    }    
    // returns all the clusters indexed by target
    public TreeMap<String, List<PeakCluster>> allIndexedClusters(int limit) throws Exception {
        TreeMap<String, List<PeakCluster>> ret = new TreeMap<>();
        for (PeakCluster cluster : getAllPeakClusters(limit)) {
            String target = cluster.getTarget();
            List<PeakCluster> list = ret.get(target);
            if (list == null) {
                list = new ArrayList<>();
                ret.put(target, list);
            }
            list.add(cluster);
        }
        return ret;
    }

    // returns all the targets
    public TreeSet<String> getClusterTargets()throws Exception {
        TreeSet<String> ret = new TreeSet<>();
        if (clusters == null){
            clusters = this.getAllPeakClusters(Integer.MAX_VALUE);
        }        

        for (PeakCluster cluster : clusters) {
            ret.add(cluster.getTarget());
        }
        return ret;
    }
    public int[] distributionOfClusterSizes()throws Exception {
        int maxN = 0;
        TreeMap<Integer,Integer> countsMap = new TreeMap<>();
        for (PeakCluster cluster : this.getAllPeakClusters(Integer.MAX_VALUE)){
            int n = cluster.getTFs().size();
            Integer count = countsMap.get(n);
            if (count == null){
                countsMap.put(n,1);
            } else {
                countsMap.put(n, count+1);
            }
            if (n > maxN){
                maxN = n;
            }
        }
        int[] ret = new int[maxN+1];
        for (int i=0 ; i<maxN ; ++i){
            Integer count = countsMap.get(i);
            if (count == null){
                ret[i] =0;
            } else {
                ret[i] = count;
            }
        }
        return ret;
    }
     public List<PeakCluster> getAllPeakClusters(int min,int max){
        ArrayList<PeakCluster> ret = new ArrayList<>();
        for (PeakCluster cluster : clusters) {
            int n = cluster.getTFs().size();
            if (min<=n && n<=max){
                ret.add(cluster);
            }
        }
        return ret;        
     }
             
    // get all peak clusters with fewer tfs than given limit
    public List<PeakCluster> getAllPeakClusters(int maxSizeCluster) throws Exception {
        ArrayList<PeakCluster> ret = new ArrayList<>();
        for (PeakCluster cluster : clusters) {
            if (cluster.getTFs().size() <= maxSizeCluster){
                ret.add(cluster);
            }
        }        
        return ret;
    }

    public List<PeakCluster> getClustersOnChromosome(String chr) throws Exception {
        return this.getClustersMeanWithin(chr, 0, Integer.MAX_VALUE);
    }
    public List<PeakCluster> getClustersForTarget(String target) throws Exception {

        ArrayList<PeakCluster> ret = new ArrayList<>();
        for (PeakCluster cluster : clusters) {
            if (cluster.getTarget().equals(target)){
                ret.add(cluster);
            }
        }
        return ret;        
    }
    // get the peak clusters that contain all the given tfs
    public List<PeakCluster> getClustersWithAll(String[] tfs) throws Exception {
        ArrayList<PeakCluster> ret = new ArrayList<>();

        for (PeakCluster cluster : clusters) {
            boolean found = true;
            for (String tf : tfs) {
                if (!cluster.containsTF(tf)) {
                    found = false;
                    break;
                }
            }
            if (found) {
                ret.add(cluster);
            }
        }
        return ret;
    }

    // find clusters in the genomic range inclusive
    public List<PeakCluster> getClustersMeanWithin(String chr, int low, int high) throws Exception {
        ArrayList<PeakCluster> ret = new ArrayList<>();
        for  (PeakCluster cluster : this.clusters) {
            if (cluster.getChromosome().equals(chr) && cluster.getMeanPosition() >= low && cluster.getMeanPosition() <= high) {
                ret.add(cluster);
            }
        }
        return ret;
    }

    public PeakCluster getClusterAt(String chr, int pos) throws Exception {
        for  (PeakCluster cluster : this.clusters) {

            if (cluster.getChromosome().equals(chr) && cluster.getMeanPosition() == pos) {
                return cluster;
            }

        }
        return null;
    }

    public Set<String> getChipedTFs() throws Exception {
        TreeSet<String> ret = new TreeSet<>();

        for  (PeakCluster cluster : this.clusters) {
            ret.addAll(cluster.getTFs());
        }
        return ret;
    }

    // determine if the peak clusters associated with a set of target genes is enriched for ech tf
    public int clusterEnrichment(Set<String> targetGenes, TreeMap<String, Integer> map, int limit) throws Exception {
        int N = 0;
        for (PeakCluster cluster : this.getAllPeakClusters(limit)) {

            
            String peakTarget = cluster.possibleTarget();
                if (targetGenes.isEmpty() || targetGenes.contains(peakTarget)) {
                    ++N;
                    for (String tf : cluster.getTFs()) {
                        Integer k = map.get(tf);
                        if (k == null) {
                            k = 1;
                        } else {
                            k = k + 1;
                        }
                        map.put(tf, k);
                    }
                }
        }
        return N;
    }

    public int geneEnrichment(Set<String> targetGenes, TreeMap<String, List<PeakCluster>> clusterMap, TreeMap<String, Integer> map, int limit) throws Exception {
        int N = 0;
        for (String target : clusterMap.keySet()) {
            if (targetGenes.contains(target)) {
                ++N;
                Set<String> tfs = new TreeSet<>();
                for (PeakCluster cluster : clusterMap.get(target)) {
                    for (String tf : cluster.getTFs()) {
                        tfs.add(tf);
                    }
                }
                for (String tf : tfs) {
                    Integer n = map.get(tf);
                    if (n == null) {
                        map.put(tf, 1);
                    } else {
                        map.put(tf, n + 1);
                    }
                }
            }
        }
        return N;

    }

    static public void main(String[] args) throws Exception {
        ClusterReportFile file = new ClusterReportFile(new File("/net/waterston/vol2/home/gevirl/Embryonic_LarvalPeakClusters.tab"));
        TreeMap<String, Integer> map = new TreeMap<>();
        int n = file.clusterEnrichment(new TreeSet<>(), map, 50);

        Set<String> chippedTFs = file.getChipedTFs();
        String[] tfs = {"egl-5", "lin-39", "mab-5", "rnt-1"};

//        List<PeakCluster> list = file.getClustersMeanWithin("chrIV", 13704113, 13704316);
        List<PeakCluster> list = file.getClustersWithAll(tfs);
        TreeSet<String> targets = new TreeSet<>();
        for (PeakCluster cluster : list) {
            targets.add(cluster.possibleTarget());
        }
        int uiasdfuhs = 0;
    }
}
