/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.ChipSeq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.primefaces.model.TreeNode;
import org.rhwlab.encode.objects.EncodeObject;
import org.rhwlab.genetype.FlyGeneTypes;
import org.rhwlab.genetype.GeneTypes;
import org.rhwlab.genetype.WormGeneTypes;
import org.rhwlab.modern.Experiment;
import org.rhwlab.modern.LifeStage;
import org.rhwlab.modern.OrthologTF;
import org.rhwlab.modern.ReferenceGenome;
import org.rhwlab.modern.Species;
import org.rhwlab.modern.TF;

/**
 *
 * @author gevirl
 */
public class ViewByTF extends ViewBase implements Serializable  {
    IndexedSelection selection;
    
    public void buildTree()throws Exception {
        GeneTypes geneTypes;
        if (species.equalsIgnoreCase("worm")){
            geneTypes = new WormGeneTypes();
        } else {
            geneTypes = new FlyGeneTypes();
        }
        assembly = choosenAssembly();
        root = new Species(assembly,species,null);
        
        String[] allTFs = selection.getAllTFs();
        Arrays.sort(allTFs,new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                return s1.compareToIgnoreCase(s2);
            }
        });
        for (String tf : allTFs){
            String[] orthologs = selection.getOrthologs(tf);
            TF tfNode = null;
          
            TreeMap<String,String[]> stages = selection.getAccessionsForTF(tf);
            for (String stage : stages.keySet()){
                String[] expAccs  = stages.get(stage);
                for (String expAcc : expAccs){
                    EncodeObject expObj = selection.getEncodeObject(expAcc);
                    Experiment exp = new Experiment(expObj.getJsonObject());
                    
                    if (tfNode == null){
                        if (orthologs==null){
                            tfNode = new TF(assembly,tf,root,geneTypes.getType(tf));
                        }else {
                            tfNode = new OrthologTF(assembly,tf,root,geneTypes.getType(tf));
                            ArrayList<String> oList = new ArrayList<>();
                            for(String ortholog : orthologs){
                                oList.add(ortholog);
                            }
                            ((OrthologTF)tfNode).setOrthologs(oList);
                        }                          
                    }
                    tfNode.setDbxref(exp.getDbxref());
                    TreeNode stageNode = new LifeStage(assembly,exp,tfNode);
                    addFiles(stageNode,exp,assembly);
                }
            }
        }        
        peaksUrlsMap.clear();
        addPeaksURLs(root, peaksUrlsMap);       
        
    }
    
    public TreeNode getRoot() throws Exception {    
        String choosen = choosenAssembly();
        if (root==null || !choosen.equals(assembly)){
            buildTree();
        }
        return root;
    }

    
    @Override
    public String getZipFileName() {
        return String.format("%sByTF.zip", species);
    }
    public void setSelection(IndexedSelection s){
        this.selection = s;
    }
    
    public List<TF> getAllTFs() throws Exception {
        List<TF> ret = new ArrayList<>();
        TreeNode root = this.getRoot();
        for (TreeNode node : root.getChildren()){
            ret.add((TF)node);
        }
        return ret;
    }
    
    static public void main(String[] args) throws Exception {
        ViewByTF vbs = new ViewByTF();
        vbs.setSpecies("worm");
        vbs.setGenomes(new ReferenceGenome());
        java.io.File dir = new java.io.File("/net/waterston/vol2/home/gevirl/ReleasedWormChipSeqExperiments");
        IndexedSelection sel = new ReleasedWormSelection(dir);
        vbs.setSelection(sel);
        vbs.buildTree();
        int uiashdfs=0;
    }
}
