/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.ChipSeq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import org.primefaces.model.TreeNode;
import org.rhwlab.encode.objects.EncodeObject;
import org.rhwlab.genetype.FlyGeneTypes;
import org.rhwlab.genetype.GeneTypes;
import org.rhwlab.genetype.WormGeneTypes;
import org.rhwlab.modern.Experiment;
import org.rhwlab.modern.LifeStage;
import org.rhwlab.modern.OrthologTF;
import org.rhwlab.modern.ReferenceGenome;
import org.rhwlab.modern.Species;
import org.rhwlab.modern.TF;

/**
 *
 * @author gevirl
 */
public class ViewByStage extends ViewBase implements Serializable  {
    IndexedSelection selection;
    
    public void buildTree()throws Exception {
        GeneTypes geneTypes;
        if (species.equalsIgnoreCase("worm")){
            geneTypes = new WormGeneTypes();
        } else {
            geneTypes = new FlyGeneTypes();
        }
        assembly = choosenAssembly();
        root = new Species(assembly,species,null);
        String[] allStages = selection.getAllStages();
        Arrays.sort(allStages);
        for (String stage : allStages){
            TreeNode stageNode = new LifeStage(stage,root);
            TreeMap<String,String[]> tfs = selection.getAccessionsForStage(stage);
            for (String tf : tfs.keySet()){
                String[] expAccs  = tfs.get(tf);
                for (String expAcc : expAccs){

                    EncodeObject expObj = selection.getEncodeObject(expAcc);
                    Experiment exp = new Experiment(expObj.getJsonObject());
                    TreeNode tfNode;
                    String[] orthologs = selection.getOrthologs(tf);
                    if (orthologs==null){
                        tfNode = new TF(assembly,exp,stageNode,geneTypes.getType(tf));
                    }else {
                        tfNode = new OrthologTF(assembly,exp,stageNode,geneTypes.getType(tf));
                        ArrayList<String> oList = new ArrayList<>();
                        for(String ortholog : orthologs){
                            oList.add(ortholog);
                        }
                        ((OrthologTF)tfNode).setOrthologs(oList);
                    }
                    addFiles(tfNode,exp,assembly);
                }
            }
        }        
        peaksUrlsMap.clear();
        addPeaksURLs(root, peaksUrlsMap);       
        
    }
    
    public TreeNode getRoot() throws Exception {    
        String choosen = choosenAssembly();
        if (root==null || !choosen.equals(assembly)){
            buildTree();
        }
        return root;
    }

    
    @Override
    public String getZipFileName() {
        return String.format("%sByStage.zip", species);
    }
    public void setSelection(IndexedSelection s){
        this.selection = s;
    }
    
    static public void main(String[] args) throws Exception {
        ViewByStage vbs = new ViewByStage();
        vbs.setSpecies("worm");
        vbs.setGenomes(new ReferenceGenome());
        java.io.File dir = new java.io.File("/net/waterston/vol2/home/gevirl/ReleasedWormChipSeqExperiments");
        IndexedSelection sel = new ReleasedWormSelection(dir);
        vbs.setSelection(sel);
        vbs.buildTree();
        int uiashdfs=0;
    }
}
