/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.ChipSeq;

import java.util.TreeMap;
import org.primefaces.model.TreeNode;
import org.rhwlab.UCSC.TrackHub;
import org.rhwlab.modern.ReferenceGenome;
import org.rhwlab.modern.TF;

/**
 *
 * @author gevirl
 */
public class TrackHubs {
    static public void main(String[] args)throws Exception {
        java.io.File hubDir = new java.io.File(args[0]);
        
        ReleasedFlySelection fly = new ReleasedFlySelection(new java.io.File(hubDir, "ReleasedFlyChipSeqExperiments"));
        ReleasedWormSelection worm = new ReleasedWormSelection(new java.io.File(hubDir, "ReleasedWormChipSeqExperiments"));
        
        ReferenceGenome genome = new ReferenceGenome();

        TreeMap<String, String[]> assemblyMap = new TreeMap<>();
        String[] flyAssemblies = {"dm3", "dm6"};
        String[] wormAssemblies = {"ce10", "ce11"};
//        assemblyMap.put("worm", wormAssemblies);
        assemblyMap.put("fly", flyAssemblies); 
        
        // build ing the trackhubs for each species (each species trackhub includes both assemblies)
        for (String species : assemblyMap.keySet()) {
            ViewByTF view = new ViewByTF();
            view.setGenomes(genome);
            view.setSpecies(species);
            IndexedSelection selection = null;
            if (species.equals("worm")){
                selection = worm;
            } else {
                selection = fly;
            }   
            view.setSelection(selection);
            TreeNode[] roots = new TreeNode[assemblyMap.get(species).length];
            String[] assemblies = assemblyMap.get(species);
            for (int i=0 ; i<assemblies.length ; ++i){
                roots[i] = view.getRoot();
            }
            for (TF tf : view.getAllTFs()){
                TrackHub.formTFhtml(tf, hubDir); 
                TrackHub.formHub(tf.getId(),roots,hubDir,species,assemblies);
                int oihdfisd=0;
            }
            TrackHub.formHub(null,roots,hubDir,species,assemblies);
        }        
    }
}
