/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.ChipSeq;

import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import org.rhwlab.cgc.CGCStrain;
import org.rhwlab.encode.objects.EncodeObject;
import org.rhwlab.modern.Experiment;

/**
 *
 * @author gevirl
 */
public class ReleasedWormSelection extends IndexedSelection implements Serializable {
    public ReleasedWormSelection(java.io.File dir) throws Exception {
        super(dir, ReleasedWormExperiment.class.newInstance().getClass());
    }
    
    public ReleasedWormSelection() throws Exception {
        super(ReleasedWormExperiment.class.newInstance().getClass());
    } 
    
    // set up the cgc strain directory
    public void cgcStrains()throws Exception {
        if (indexedDir == null) {
            indexedDir = new java.io.File(this.getDirectory()).getParentFile();
        }
        // form tf and stage indexes with links for the non-control experiments
        for (int i = 0; i < this.getObjectCount(); ++i) {
            EncodeObject expObj = this.getEncodeObject(i);
            Experiment exp = new Experiment(expObj.getJsonObject());
            String strain = exp.getStrain();
            if (strain != null){
                java.io.File strainsDir = new java.io.File(indexedDir,"strains");
                Files.createDirectories(strainsDir.toPath());
                java.io.File strainFile = new java.io.File(strainsDir,strain);
                if (!strainFile.exists()){
                    CGCStrain cgc = new CGCStrain(strain);
                    String url = cgc.getUrl();
                    if (url != null){
                        PrintStream stream = new PrintStream(strainFile );
                        stream.println(url);
                        stream.close();
                    }
                }
            }
        }
    }
}
