/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.ChipSeq;

import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.rhwlab.UCSC.AggregateBed;
import org.rhwlab.encode.ChipSeq.peaks.PeakClusters;
import org.rhwlab.encode.ChipSeq.peaks.PeakFile;
import org.rhwlab.gene.model.ModelFromGFF;
import org.rhwlab.modern.ReferenceGenome;
import org.rhwlab.chipseq.ChipSeqBedRecord;

/**
 *
 * @author gevirl
 */
// build the aggregated and clustered peak beds
// args[0] - selection directory 
// args[1+] - stages , all if none listed
public class PeakBeds {

    static final Set<String> embryonicStages = new TreeSet<>(Arrays.asList("earlyembryonic", "lateembryonic", "midembryonic", "mixedstage(embryonic)"));
    static final Set<String> earlyLarvalStages = new TreeSet<>(Arrays.asList("L1larva", "L2larva", "L3larva"));
    static final Set<String> embryonicLarvalStages = new TreeSet<>();
    static final Map<String,Set<String>> stageSets = new TreeMap<>();
    static {
        embryonicLarvalStages.addAll(embryonicStages);
        embryonicLarvalStages.addAll(earlyLarvalStages);
        stageSets.put("",null);
        stageSets.put("EarlyLarval", earlyLarvalStages);
        stageSets.put("Embryonic", embryonicStages);
        stageSets.put("EmbryonicLarval", embryonicLarvalStages);
    }

    static public void makeAllWormStageSets(String dir,String assembly)throws Exception {
        ModelFromGFF gff3 = new ModelFromGFF(new java.io.File("/net/waterston/vol9/References/WS245/AllWormBase.withTransposon.gff3"));
        for (String label : stageSets.keySet()){
            Set<String> stageSet = stageSets.get(label);
            makeWormPeakBeds( dir, assembly,  gff3, stageSet, label);
        }
    }
    static public void makeWormPeakBeds(String dir, String assembly, ModelFromGFF gff3, Set<String> stages, String label) throws Exception {
        String species = "worm";
        ReleasedWormSelection worm = new ReleasedWormSelection(new java.io.File(dir, "ReleasedWormChipSeqExperiments"));
        ReferenceGenome genome = new ReferenceGenome();
        genome.setAssembly(species, assembly);
        ViewByTF view = new ViewByTF();
        view.setGenomes(genome);
        view.setSpecies(species);
        view.setSelection(worm);

        AggregateBed aggBed = new AggregateBed(view.getRoot(), "spp.optimal", "gz", stages);
        java.io.File assemblyDir = new java.io.File(dir, assembly);
        Files.createDirectories(assemblyDir.toPath());
        java.io.File narrowBedFile = new java.io.File(assemblyDir, label + "narrowPeak.bed");
        java.io.File narrowBBFile = new java.io.File(assemblyDir, label + "narrowPeak.bb");
        java.io.File singleBedFile = new java.io.File(assemblyDir, label + "singlePeak.bed");
        java.io.File singleBBFile = new java.io.File(assemblyDir, label + "singlePeak.bb");
        
        
        aggBed.writeTo(narrowBedFile);
        String cmd = String.format("/net/waterston/vol9/bedSort  %s  %s.sort",
                narrowBedFile.getPath(), narrowBedFile.getPath());
        Process p = Runtime.getRuntime().exec(cmd);
        p.waitFor();

        cmd = String.format("/net/waterston/vol9/bedToBigBed -type=bed6+4 -as=/net/waterston/vol9/narrowPeak.as  %s.sort /net/waterston/vol9/%s.chrom.sizes %s",
                narrowBedFile.getPath(), assembly, narrowBBFile.getPath());
        p = Runtime.getRuntime().exec(cmd);
        p.waitFor();

        aggBed.writePointBedTo(singleBedFile);
        cmd = String.format("/net/waterston/vol9/bedToBigBed -type=bed6+3  %s /net/waterston/vol9/%s.chrom.sizes %s",
                singleBedFile.getPath(), assembly, singleBBFile.getPath());
        p = Runtime.getRuntime().exec(cmd);
        p.waitFor();

        Runtime.getRuntime().exec(String.format("chmod 666 %s", narrowBedFile.getPath()));
        Runtime.getRuntime().exec(String.format("chmod 666 %s", singleBedFile.getPath()));        
        Runtime.getRuntime().exec(String.format("chmod 666 %s", narrowBBFile.getPath()));
        Runtime.getRuntime().exec(String.format("chmod 666 %s", singleBBFile.getPath()));

        // build the clustered peaks bed file for each species and assembly
        java.io.File annotBedFile = new java.io.File(assemblyDir, label + "annotatedPeak.bed");
        java.io.File peakClusterBedFile = new java.io.File(assemblyDir, label + "PeakClusters.bed");
        java.io.File peakClusterTabFile = new java.io.File(assemblyDir, label + "PeakClusters.tab");
        java.io.File peakClusterBBFile = new java.io.File(assemblyDir, label + "PeakClusters.bb");
        ArrayList<PeakFile> peakFiles = new ArrayList<>();
        TreeMap<String, List<ChipSeqBedRecord>> map = aggBed.getBedRecords();
        for (String tf : map.keySet()) {
            peakFiles.add(new PeakFile(map.get(tf), tf));
        }

        PeakClusters peakClusters = new PeakClusters(peakFiles, 60);
        peakClusters.locateInGenome(gff3);   // this annotates the bed records with the cluster and target 
        peakClusters.report(peakClusterTabFile);
        peakClusters.toBedFormat(peakClusterBedFile.getPath());
        cmd = String.format("/net/waterston/vol9/bedToBigBed -type=bed9  %s /net/waterston/vol9/%s.chrom.sizes %s",
                peakClusterBedFile.getPath(), assembly, peakClusterBBFile.getPath());
        p = Runtime.getRuntime().exec(cmd);
        p.waitFor();
        Runtime.getRuntime().exec(String.format("chmod 666 %s", peakClusterBBFile.getPath()));
        Runtime.getRuntime().exec(String.format("chmod 666 %s", peakClusterTabFile.getPath()));
        Runtime.getRuntime().exec(String.format("chmod 666 %s", peakClusterBedFile.getPath()));
        Runtime.getRuntime().exec(String.format("chmod 666 %s", annotBedFile.getPath()));
        aggBed.writeTo(annotBedFile);
        int iushfu=0;
    }

    static public void main(String[] args) throws Exception {
        String dir = args[0];
        
        makeAllWormStageSets(dir,"ce11");
/*        
        ModelFromGFF gff3 = new ModelFromGFF(new java.io.File("/net/waterston/vol9/References/WS245/AllWormBase.withTransposon.gff3"));

        
        ReleasedFlySelection fly = new ReleasedFlySelection(new java.io.File(dir, "ReleasedFlyChipSeqExperiments"));
        ReleasedWormSelection worm = new ReleasedWormSelection(new java.io.File(dir, "ReleasedWormChipSeqExperiments"));

        ReferenceGenome genome = new ReferenceGenome();

        TreeMap<String, String[]> assemblyMap = new TreeMap<>();
        String[] flyAssemblies = {"dm3", "dm6"};
        String[] wormAssemblies = {"ce10", "ce11"};
        assemblyMap.put("worm", wormAssemblies);
        assemblyMap.put("fly", flyAssemblies);
        for (String species : assemblyMap.keySet()) {
            for (String assembly : assemblyMap.get(species)) {
                ViewByTF view = new ViewByTF();
                view.setGenomes(genome);
                view.setSpecies(species);
                if (species.equals("worm")) {
                    view.setSelection(worm);
                } else {
                    view.setSelection(fly);
                }

                // form the aggregated optimal peak bed files for each species and assembly
                genome.setAssembly(species, assembly);
//                AggregateBed aggBed = new AggregateBed(view.getRoot(), "optimal idr thresholded peaks", "gz");
                AggregateBed aggBed = new AggregateBed(view.getRoot(), "spp.optimal", "gz");
                java.io.File assemblyDir = new java.io.File(dir, assembly);
                Files.createDirectories(assemblyDir.toPath());
                java.io.File narrowBedFile = new java.io.File(assemblyDir, "narrowPeak.bed");
                java.io.File narrowBBFile = new java.io.File(assemblyDir, "narrowPeak.bb");
                java.io.File singleBedFile = new java.io.File(assemblyDir, "singlePeak.bed");
                java.io.File singleBBFile = new java.io.File(assemblyDir, "singlePeak.bb");

                aggBed.writeTo(narrowBedFile);
                String cmd = String.format("/net/waterston/vol9/bedSort  %s  %s.sort",
                        narrowBedFile.getPath(), narrowBedFile.getPath());
                Process p = Runtime.getRuntime().exec(cmd);
                p.waitFor();

                cmd = String.format("/net/waterston/vol9/bedToBigBed -type=bed6+4 -as=/net/waterston/vol9/narrowPeak.as  %s.sort /net/waterston/vol9/%s.chrom.sizes %s",
                        narrowBedFile.getPath(), assembly, narrowBBFile.getPath());
                p = Runtime.getRuntime().exec(cmd);
                p.waitFor();

                aggBed.writePointBedTo(singleBedFile);
                cmd = String.format("/net/waterston/vol9/bedToBigBed -type=bed6+3  %s /net/waterston/vol9/%s.chrom.sizes %s",
                        singleBedFile.getPath(), assembly, singleBBFile.getPath());
                p = Runtime.getRuntime().exec(cmd);
                p.waitFor();

                Runtime.getRuntime().exec(String.format("chmod 666 %s", narrowBBFile.getPath()));
                Runtime.getRuntime().exec(String.format("chmod 666 %s", singleBBFile.getPath()));

                // build the clustered peaks bed file for each species and assembly
                if (species.equals("worm")) {
                    java.io.File peakClusterBedFile = new java.io.File(assemblyDir, "PeakClusters.bed");
                    java.io.File peakClusterBBFile = new java.io.File(assemblyDir, "PeakClusters.bb");
                    ArrayList<PeakFile> peakFiles = new ArrayList<>();
                    TreeMap<String, List<BedRecord>> map = aggBed.getBedRecords();
                    for (String tf : map.keySet()) {
                        peakFiles.add(new PeakFile(map.get(tf), tf));
                    }

                    PeakClusters peakClusters = new PeakClusters(peakFiles, 60);
                    peakClusters.locateInGenome(gff3);
                    peakClusters.toBedFormat(peakClusterBedFile.getPath());
                    cmd = String.format("/net/waterston/vol9/bedToBigBed -type=bed9  %s /net/waterston/vol9/%s.chrom.sizes %s",
                            peakClusterBedFile.getPath(), assembly, peakClusterBBFile.getPath());
                    p = Runtime.getRuntime().exec(cmd);
                    p.waitFor();
                    Runtime.getRuntime().exec(String.format("chmod 666 %s", peakClusterBBFile.getPath()));
                }
            }
        }
*/
    }

}
