/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.ChipSeq;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.primefaces.model.TreeNode;
import org.rhwlab.UCSC.AggregateBed;
import org.rhwlab.UCSC.TrackHub;
import org.rhwlab.encode.ChipSeq.peaks.PeakClusters;
import org.rhwlab.encode.ChipSeq.peaks.PeakFile;
import org.rhwlab.encode.objects.Experiment;
import org.rhwlab.modern.ReferenceGenome;
import org.rhwlab.modern.TF;
import org.rhwlab.chipseq.ChipSeqBedRecord;

/**
 *
 * @author gevirl
 */
public class Orthologs {

    public TreeMap buildOrthologMap(String file) throws Exception {
        TreeMap<String, List<String>> ret = new TreeMap<>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(file)));
        String line = reader.readLine();
        while (line != null) {
            String[] tokens = line.split("\t");
            List<String> list = ret.get(tokens[0]);
            if (list == null) {
                list = new ArrayList<>();
                ret.put(tokens[0], list);
            }
            list.add(tokens[1]);
            line = reader.readLine();
        }
        reader.close();
        return ret;
    }

    static public void formLinks(IndexedSelection fromSel, IndexedSelection toSel, TreeMap<String, List<String>> orthologMap) throws Exception {
        TreeMap<String, String> toNameMap = toSel.getDbxrefsToGeneName();  // maps dbxref -> common name for experiments in the to selection

        for (int i = 0; i < fromSel.getObjectCount(); ++i) {
            Experiment exp = (Experiment) fromSel.getEncodeObject(i);
            String geneName = exp.getGeneName();
            String dbxref = exp.getDbxref();
            if (geneName != null && dbxref != null) {
                List<String> orthologList = orthologMap.get(dbxref);  // all possible orthologs (all may not be chipped)
                if (orthologList != null) {
                    for (String orthoDbxref : orthologList) {
                        String orthoGene = toNameMap.get(orthoDbxref); // ortholog is in the to selection ?
                        if (orthoGene != null) {
                            // form the link
                            fromSel.orthoLink(geneName, toSel, orthoGene);
                        }
                    }
                }
            }
        }
    }

    static public void reportLinks(IndexedSelection fromSel, IndexedSelection toSel, TreeMap<String, List<String>> orthologMap) throws Exception {
        TreeMap<String, String> toNameMap = toSel.getDbxrefsToGeneName();  // maps dbxref -> common name for experiments in the to selection

        for (int i = 0; i < fromSel.getObjectCount(); ++i) {
            Experiment exp = (Experiment) fromSel.getEncodeObject(i);
            String geneName = exp.getGeneName();
            String dbxref = exp.getDbxref();
            if (geneName != null && dbxref != null) {
                List<String> orthologList = orthologMap.get(dbxref);  // all possible orthologs (all may not be chipped)
                if (orthologList != null) {
                    for (String orthoDbxref : orthologList) {
                        String orthoGene = toNameMap.get(orthoDbxref); // ortholog is in the to selection ?
                        if (orthoGene != null) {
                            // form the link
                            System.out.printf("%s\t%s\n",geneName, orthoGene);
                        }
                    }
                }
            }
        }
    }    

    // download the dcc and form the ortholog links
    // args[0] - directory to put all the data 
    static public void main(String[] args) throws Exception {
        java.io.File hubDir = new java.io.File(args[0]);
        Orthologs ortho = new Orthologs();

        // get all the released worm experiments and build indexes
        ReleasedWormSelection worm = new ReleasedWormSelection();
        worm.saveToDirectory(new java.io.File(args[0], "ReleasedWormChipSeqExperiments"));
        worm.indexDirectory();
        worm.cgcStrains();

        // get all the released fly experiments and build indexes
        ReleasedFlySelection fly = new ReleasedFlySelection();
        fly.saveToDirectory(new java.io.File(args[0], "ReleasedFlyChipSeqExperiments"));
        fly.indexDirectory();

        // set up the the orhtolog indexes
        Orthologs.formLinks(fly, worm, ortho.buildOrthologMap("/org/rhwlab/encode/ortholog/FBgnToWBGene.all.orthologs"));
        Orthologs.formLinks(worm, fly, ortho.buildOrthologMap("/org/rhwlab/encode/ortholog/WBGeneToFBgn.all.orthologs"));

 /*               
        ReleasedFlySelection fly = new ReleasedFlySelection(new java.io.File(args[0],"ReleasedFlyChipSeqExperiments"));
        fly.indexDirectory();
        ReleasedWormSelection worm = new ReleasedWormSelection(new java.io.File(args[0],"ReleasedWormChipSeqExperiments"));
        worm.indexDirectory();
 */       
        ReferenceGenome genome = new ReferenceGenome();

        TreeMap<String, String[]> assemblyMap = new TreeMap<>();
        String[] flyAssemblies = {"dm3", "dm6"};
        String[] wormAssemblies = {"ce10", "ce11"};
        assemblyMap.put("worm", wormAssemblies);
        assemblyMap.put("fly", flyAssemblies);
        
        // build the track files 
        for (String species : assemblyMap.keySet()) {
            for (String assembly : assemblyMap.get(species)) {
                ViewByTF view = new ViewByTF();
                view.setGenomes(genome);
                view.setSpecies(species);
                if (species.equals("worm")){
                    view.setSelection(worm);
                } else {
                    view.setSelection(fly);
                }
                
                // form the aggregated optimal peak bed files for each species and assembly
                genome.setAssembly(species, assembly);
//                AggregateBed aggBed = new AggregateBed(view.getRoot(), "optimal idr thresholded peaks", "gz");
                AggregateBed aggBed = new AggregateBed(view.getRoot(), "spp.optimal", "gz");                 
                java.io.File assemblyDir = new java.io.File(args[0], assembly);
                Files.createDirectories(assemblyDir.toPath());
                java.io.File narrowBedFile = new java.io.File(assemblyDir, "narrowPeak.bed");
                java.io.File narrowBBFile = new java.io.File(assemblyDir, "narrowPeak.bb");
                java.io.File singleBedFile = new java.io.File(assemblyDir, "singlePeak.bed");
                java.io.File singleBBFile = new java.io.File(assemblyDir, "singlePeak.bb");
                java.io.File peakClusterBedFile = new java.io.File(assemblyDir, "peakClusters.bed");
                java.io.File peakClusterBBFile = new java.io.File(assemblyDir, "peakClusters.bb");

                aggBed.writeTo(narrowBedFile);
                String cmd = String.format("/net/waterston/vol9/bedToBigBed -type=bed6+4 -as=/net/waterston/vol9/narrowPeak.as  %s /net/waterston/vol9/%s.chrom.sizes %s",
                        narrowBedFile.getPath(), assembly, narrowBBFile.getPath());
                Process p = Runtime.getRuntime().exec(cmd);
                p.waitFor();

                aggBed.writePointBedTo(singleBedFile);
                cmd = String.format("/net/waterston/vol9/bedToBigBed -type=bed6+3  %s /net/waterston/vol9/%s.chrom.sizes %s",
                        singleBedFile.getPath(), assembly, singleBBFile.getPath());
                p = Runtime.getRuntime().exec(cmd);
                p.waitFor();

                Runtime.getRuntime().exec(String.format("chmod 666 %s", narrowBBFile.getPath()));
                Runtime.getRuntime().exec(String.format("chmod 666 %s", singleBBFile.getPath()));
                
                // build the clustered peaks bed file for each species and assembly
                ArrayList<PeakFile> peakFiles = new ArrayList<>();
                TreeMap<String,List<ChipSeqBedRecord>> map = aggBed.getBedRecords();
                for (String tf : map.keySet()){
                    peakFiles.add(new PeakFile(map.get(tf),tf));
                }
                PeakClusters peakClusters = new PeakClusters(peakFiles,60);
                peakClusters.toBedFormat(peakClusterBedFile.getPath());
                cmd = String.format("/net/waterston/vol9/bedToBigBed -type=bed9  %s /net/waterston/vol9/%s.chrom.sizes %s",
                        peakClusterBedFile.getPath(), assembly, peakClusterBBFile.getPath());
                p = Runtime.getRuntime().exec(cmd);
                p.waitFor();                
            }
        }
        
        
        // build ing the trackhubs for each species (each species trackhub includes both assemblies)
        for (String species : assemblyMap.keySet()) {
            ViewByTF view = new ViewByTF();
            view.setGenomes(genome);
            view.setSpecies(species);
            IndexedSelection selection = null;
            if (species.equals("worm")){
                selection = worm;
            } else {
                selection = fly;
            }   
            view.setSelection(selection);
            TreeNode[] roots = new TreeNode[assemblyMap.get(species).length];
            String[] assemblies = assemblyMap.get(species);
            for (int i=0 ; i<assemblies.length ; ++i){
                roots[i] = view.getRoot();
            }
            for (TF tf : view.getAllTFs()){
                TrackHub.formTFhtml(tf, hubDir); 
                TrackHub.formHub(tf.getId(),roots,hubDir,species,assemblies);
                int oihdfisd=0;
            }
        }
    }
}
