/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.ChipSeq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeMap;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.primefaces.model.TreeNode;
import org.rhwlab.encode.objects.EncodeObject;
import org.rhwlab.genetype.FlyGeneTypes;
import org.rhwlab.genetype.GeneTypes;
import org.rhwlab.genetype.WormGeneTypes;
import org.rhwlab.modern.Experiment;
import org.rhwlab.modern.LifeStage;
import org.rhwlab.modern.OrthologTF;
import org.rhwlab.modern.Species;
import org.rhwlab.modern.TF;

/**
 *
 * @author gevirl
 */
public class OrthologView extends ViewBase  implements Serializable  {
    String dbxref;
    IndexedSelection wormSelection;
    IndexedSelection flySelection;
    String title;
    String commonName;
    
    public OrthologView(){
        HttpServletRequest req = (HttpServletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
        dbxref = req.getParameter("TF");  
        if (dbxref.startsWith("WB")){
            species = "worm";
        } else {
            species = "fly";
        }
    }

    public TreeNode getRoot() throws Exception {    
        String choosen = choosenAssembly();
        if (root==null || !choosen.equals(assembly)){
            buildTree();
        }
        return root;
    }   
    public void buildTree()throws Exception {
        String[] orthoTFs;
        GeneTypes geneTypes;
        IndexedSelection selection;
        if (dbxref.startsWith("FB")){
            geneTypes = new WormGeneTypes();
            selection = wormSelection;
            orthoTFs = flySelection.getOrthologsFromDbxref(dbxref);
            commonName = flySelection.getCommonName(dbxref);
            assembly = this.genomes.getWorm();
        } else {
            geneTypes = new FlyGeneTypes();
            selection = flySelection;
            orthoTFs = wormSelection.getOrthologsFromDbxref(dbxref);
            commonName = wormSelection.getCommonName(dbxref);
            assembly = this.genomes.getFly();
        }
//        assembly = choosenAssembly();
        root = new Species(assembly,species,null);
        

        if (orthoTFs == null) return;
        
        for (String tf : orthoTFs){
            String[] orthologs = selection.getOrthologs(tf);
            TF tfNode = null;
          
            TreeMap<String,String[]> stages = selection.getAccessionsForTF(tf);
            for (String stage : stages.keySet()){
                String[] expAccs  = stages.get(stage);
                for (String expAcc : expAccs){
                    EncodeObject expObj = selection.getEncodeObject(expAcc);
                    Experiment exp = new Experiment(expObj.getJsonObject());
                    
                    if (tfNode == null){
                        if (orthologs==null){
                            tfNode = new TF(assembly,tf,root,geneTypes.getType(tf));
                        }else {
                            tfNode = new OrthologTF(assembly,tf,root,geneTypes.getType(tf));
                            ArrayList<String> oList = new ArrayList<>();
                            for(String ortholog : orthologs){
                                oList.add(ortholog);
                            }
                            ((OrthologTF)tfNode).setOrthologs(oList);
                        }                          
                    }
                    tfNode.setDbxref(exp.getDbxref());
                    TreeNode stageNode = new LifeStage(assembly,exp,tfNode);
                    addFiles(stageNode,exp,assembly);
                }
            }
        }        
        peaksUrlsMap.clear();
        addPeaksURLs(root, peaksUrlsMap);       
        
    }    
    public void setWormSelection(IndexedSelection s){
        this.wormSelection = s;
    }
    public void setFlySelection(IndexedSelection s){
        this.flySelection = s;
    }    
    @Override
    public String getZipFileName() {
        return String.format("%s_Ortholog.zip",dbxref);

    }
    
    public String getTitle(){
        title = "ChipSeq";
        
        if (dbxref !=null){
            if (commonName != null){
                title = String.format("ChipSeq for Ortholog(s) of %s",commonName);
            }
        }

        return title;
    } 
    public String getUpdatedlast(){
        return flySelection.getUpdatedLast();
    }

}
