/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.encode.ChipSeq;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.TreeMap;
import org.rhwlab.encode.objects.EncodeObject;
import org.rhwlab.encode.objects.Selection;
import org.rhwlab.modern.Experiment;

/**
 *
 * @author gevirl
 */
public class IndexedSelection extends Selection implements Serializable {

    File indexedDir;

    public IndexedSelection(File dir, Class c) throws Exception {
        super(new File(dir, "experiments"), c);
        indexedDir = dir;
    }

    public IndexedSelection(Class c) throws Exception {
        super(c);
    }

    @Override
    public void setDirectory(String inDir) {
        this.indexedDir = new java.io.File(inDir);
        super.setDirectory(new java.io.File(inDir, "experiments").getPath());
    }

    // form the directories that index the experiments and create the links
    public void indexDirectory() throws Exception {
        if (indexedDir == null) {
            indexedDir = new java.io.File(this.getDirectory()).getParentFile();
        }
        // form tf and stage indexes with links for the non-control experiments
        for (int i = 0; i < this.getObjectCount(); ++i) {
            EncodeObject expObj = this.getEncodeObject(i);
            Experiment exp = new Experiment(expObj.getJsonObject());

            if (!exp.isControl()) {
                String stage = exp.getStage().replaceAll(" ", "");
                stage = stage.replace('/', '_');
                String tf = exp.getGene();
                Path tfstageDir = tfStageDir(tf, stage).toPath();
                Path stagetfDir = stageTfDir(stage, tf).toPath();
                if (exp.getDbxref()!=null){
                    Path dbxrefTFDir = dbxrefTFDir(exp.getDbxref(),tf).toPath();
                    Files.createDirectories(dbxrefDir(exp.getDbxref()).toPath());
                    if (!dbxrefTFDir.toFile().exists()){
                        Files.createSymbolicLink(dbxrefTFDir, tfDir(tf).toPath());
                    }                    
                }
                Files.createDirectories(tfstageDir);
                Files.createDirectories(stagetfDir);
                String acc = exp.getAccession();
                Path toExp = new File(new File(indexedDir, "experiments"), acc).toPath();
                File file = new File(tfstageDir.toFile(), acc);
                if (!file.exists()) {
                    Files.createLink(file.toPath(), toExp);
                }
                file = new File(stagetfDir.toFile(), acc);
                if (!file.exists()) {
                    Files.createLink(file.toPath(), toExp);
                }
            }
        }
    }

    public String[] getAllStages() {
        File stagesDir = this.stagesDir();
        return stagesDir.list();
    }

    public TreeMap<String, String[]> getAccessionsForStage(String stage) {
        TreeMap<String, String[]> ret = new TreeMap<>();

        File stageDir = this.stagesDir();
        String[] tfs = new File(stageDir, stage).list();
        for (String tf : tfs) {
            File tfDir = this.stageTfDir(stage, tf);
            ret.put(tf, tfDir.list());
        }
        return ret;
    }

    public String[] getAllTFs() {
        File tfsDir = this.tfsDir();
        return tfsDir.list();
    }

    // return accessions indexed by stage
    public TreeMap<String, String[]> getAccessionsForTF(String tf) {
        TreeMap<String, String[]> ret = new TreeMap<>();

        File tfDir = this.tfsDir();
        String[] stages = this.tfStagesDir(tf).list();
        for (String stage : stages) {
            File stageDir = this.tfStageDir(tf, stage);
            ret.put(stage, stageDir.list());
        }
        return ret;
    }

    // forms the mapping from dbxref (WBGene or FBgn) to common gene names for all experiments in the selection 
    public TreeMap<String, String> getDbxrefsToGeneName() throws Exception {
        TreeMap<String, String> ret = new TreeMap<>();
        for (int i = 0; i < this.getObjectCount(); ++i) {
            org.rhwlab.encode.objects.Experiment exp = (org.rhwlab.encode.objects.Experiment) this.getEncodeObject(i);
            String dbxref = exp.getDbxref();
            String geneName = exp.getGeneName();
            if (geneName != null && dbxref != null) {
                ret.put(dbxref, geneName);
            } else {
                int sdffcgdfggdifg = 0;
            }
        }
        return ret;
    }

    private File tfsDir() {
        return new File(this.indexedDir, "tfs");
    }

    private File dbxrefsDir(){
        return new File(this.indexedDir, "dbxrefs");
    }
    
    private File dbxrefDir(String dbxref){
        return new File(dbxrefsDir(),dbxref);
    }    
    private File dbxrefTFDir(String dbxref,String tf){
        return new File(dbxrefDir(dbxref),tf);
    }
    
    private File tfDir(String tf) {
        return new File(tfsDir(), tf);
    }

    private File tfStagesDir(String tf) {
        return new File(tfDir(tf), "stages");
    }

    private File tfStageDir(String tf, String stage) {
        return new File(tfStagesDir(tf), stage);
    }

    private File stagesDir() {
        return new File(this.indexedDir, "stages");
    }

    private File stageDir(String stage) {
        return new File(stagesDir(), stage);
    }

    private File stageTfDir(String stage, String tf) {
        return new File(stageDir(stage), tf);
    }

    private File orthologsDir(String tf) {
        return new File(tfDir(tf), "orthologs");
    }

    private File orthologDir(String tf, String ortholog) {
        return new File(orthologsDir(tf), ortholog);
    }

    // form an otholog link
    public void orthoLink(String fromGene, IndexedSelection toSel, String toGene) throws Exception {
        Path orthologsPath = orthologsDir(fromGene).toPath();
        Files.createDirectories(orthologsPath);

        Path orthologPath = orthologDir(fromGene, toGene).toPath();
        if (!orthologPath.toFile().exists()) {
            Path toPath = toSel.tfDir(toGene).toPath();
            Files.createSymbolicLink(orthologPath, toPath);
        }
    }

    public String[] getOrthologs(String tf) {
        File dir = orthologsDir(tf);
        if (dir.exists()) {
            return dir.list();
        }
        return null;
    }
    public String[] getOrthologsFromDbxref(String dbxref){
        File dbxrefDir = this.dbxrefDir(dbxref);
        if (dbxrefDir != null){
            String tf = dbxrefDir.list()[0];
            return getOrthologs(tf);
        }
        return new String[0];
    }
    public String getCommonName(String dbxref){
        File dbxrefDir = this.dbxrefDir(dbxref);
        if (dbxrefDir != null){
             return dbxrefDir.list()[0];
        }
        return "";
    }    
}
