/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.UCSC;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.primefaces.model.TreeNode;
import org.rhwlab.lang.Greek;
import org.rhwlab.modern.ControlFile;
import org.rhwlab.modern.Experiment;
import org.rhwlab.modern.ExperimentalFile;
import org.rhwlab.modern.FileType;
import org.rhwlab.modern.LifeStage;
import org.rhwlab.modern.Species;
import org.rhwlab.modern.TF;

/**
 *
 * @author gevirl
 */
// contructs a UCSC track hub for the given species and assemblies
// defaulting to display a given tf
// no tf is initialially displayed if null
public class TrackHub {

    public static void formTFhtml(TF tf, File hubdir) throws Exception {
        TreeMap<String, String> map = new TreeMap<>();
        map.put("%TF%", tf.getId());
        map.put("%EXTERNAL%", tf.getExternalLink());
        Path tfDir = new File(hubdir, "html/tf").toPath();
        Files.createDirectories(tfDir);
        replaceInTemplate(map, "/org/rhwlab/UCSC/tfTemplate.html", new File(tfDir.toFile(), String.format("%s.html", tf.getId())));

    }

    public static void formExpHtml(LifeStage stage, File hubdir) throws Exception {
        Path expDir = new File(hubdir, "html/exp").toPath();
        Files.createDirectories(expDir);
        File html = new File(expDir.toFile(), String.format("%s.html", stage.getAccession()));

        TreeMap<String, String> map = new TreeMap<>();
        map.put("%STRAIN%", stage.getStrain());
        map.put("%STAGE%", stage.getId());
        map.put("%EXP%", stage.getMetaDataLink());
        map.put("%CONTROL%", stage.getInputMetaDataLink());
        replaceInTemplate(map, "/org/rhwlab/UCSC/expTemplate.html", html);
    }

    public static void formFileHtml(ExperimentalFile f, File hubdir) throws Exception {
        Path fileDir = new File(hubdir, "html/file").toPath();
        Files.createDirectories(fileDir);
        File html = new File(fileDir.toFile(), String.format("%s.html", f.getAccession()));

        TreeMap<String, String> map = new TreeMap<>();
        map.put("%FILENAME%", f.getId());
        map.put("%METADATA%", f.getMetaDataLink());
        replaceInTemplate(map, "/org/rhwlab/UCSC/fileTemplate.html", html);
    }

    public static void formFileTypeHtml(File hubdir) throws Exception {
        Path fileDir = new File(hubdir, "html/file").toPath();
        Files.createDirectories(fileDir);
        File html = new File(String.format("%s/html/file/filetype.html", hubdir.getPath()));
        TreeMap<String, String> map = new TreeMap<>();
        replaceInTemplate(map, "/org/rhwlab/UCSC/template.html", html);
    }

    private static void replaceInTemplate(Map<String, String> map, String inResource, File html) throws Exception {
        PrintStream stream = new PrintStream(html);

        // construct an html description for the tf
        TrackHub hub = new TrackHub();
        InputStream inStream = hub.getClass().getResourceAsStream(inResource);

        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        String line = reader.readLine();
        while (line != null) {
            for (Entry entry : map.entrySet()) {
                line = line.replaceAll((String) entry.getKey(), (String) entry.getValue());
            }
            stream.println(line);
            line = reader.readLine();
        }
        reader.close();
        stream.close();
        Process p = Runtime.getRuntime().exec(String.format("chmod 666 %s", html.getPath()));

    }

    public static void formHub(String tf, TreeNode roots[], File hubDirectory, String species, String[] assemblies) throws Exception {
        Greek greek = new Greek();
        String hubId = tf;
        if (tf == null) {
            hubId = species;
        } else {
            hubId = greek.translate(tf);
        }
        System.out.printf("hub: %s\n", hubId);
        String hubFileName = String.format("%s_hub.txt", hubId);
        String genFileName = String.format("%s_genome.txt", hubId);
        String trackFileName = String.format("%s_trackDb.txt", hubId);

        // write the hub and genome files
        File hubFile = new File(hubDirectory, hubFileName);
        PrintWriter writer = new PrintWriter(hubFile);
        writer.println("hub modERN");
        writer.println("shortLabel modERN_ChipSeq");
        writer.println("longLabel modERN Transcription Factor ChipSeq");
        writer.printf("genomesFile %s\n", genFileName);
        writer.println("email gevirl@uw.edu");
        writer.close();
        Runtime.getRuntime().exec(String.format("chmod 666 %s", hubFile.getPath()));

        File genFile = new File(hubDirectory, genFileName);
        writer = new PrintWriter(genFile);
        for (int a = 0; a < assemblies.length; ++a) {
            String assembly = assemblies[a];
            writer.printf("genome %s\n", assembly);
            writer.printf("trackDb %s/%s\n", assembly, trackFileName);
            writer.println();

            File assemblyDir = new File(hubDirectory, assembly);
            if (!assemblyDir.exists()) {
                Process proc = Runtime.getRuntime().exec(String.format("mkdir -p %s", assemblyDir.getPath()));
                proc.waitFor();
                Runtime.getRuntime().exec(String.format("chmod 777 %s", assemblyDir.getPath()));
            }
            buildTrackDB(trackFileName, tf, roots[a], assemblyDir, assembly);
        }
        writer.close();
        Runtime.getRuntime().exec(String.format("chmod 666 %s", genFile.getPath()));
    }

    // construct the trackDb.txt file in the given directory
    static private void buildTrackDB(String trackFileName, String tf, TreeNode root, File dir, String assembly) throws Exception {
        File hubdir = dir.getParentFile();
        File trackFile = new File(dir, trackFileName);
        PrintWriter writer = new PrintWriter(trackFile);

        // make the aggregated tracks
        String narrowUrl = String.format("http://waterston.gs.washington.edu/modERN/%s/narrowPeak.bb", assembly);
        makeAggregateTrack("FullWidthPeak", "pack", narrowUrl, "bigNarrowPeak", writer, 1);

        String singleUrl = String.format("http://waterston.gs.washington.edu/modERN/%s/singlePeak.bb", assembly);
        makeAggregateTrack("PeakSummit", "dense", singleUrl, "bigBed 6 +", writer, 2);
        
        if (assembly.startsWith("ce")) {
            String clustersUrl = String.format("http://waterston.gs.washington.edu/modERN/%s/PeakClusters.bb", assembly);
            makePeakClusterTrack("PeakClusters", "pack", clustersUrl, "bigBed 9", writer, 3);
        }
        
        // make a super track for each TF
        for (TreeNode tfNode : root.getChildren()) {
            int nFiles = countHubFiles(tfNode);
            if (nFiles > 0) {
                makeSuperTrack(tf, tfNode, writer, hubdir);
            }
        }
        writer.close();
        Runtime.getRuntime().exec(String.format("chmod 666 %s", trackFile.getPath()));
    }

    static private void makePeakClusterTrack(String label, String vis, String url, String type, PrintWriter writer, int priority) {
        writer.printf("track %s\n", label);
        writer.printf("shortLabel %s\n", label);
        writer.printf("longLabel %s\n", label);
        writer.printf("type %s\n", type);
        writer.println("itemRgb on");
        writer.println("maxHeightPixels 128:40:15");
        writer.printf("visibility %s\n", vis);
        writer.println("autoScale on");
        writer.printf("bigDataUrl %s\n", url);
        writer.printf("priority %d\n", priority);

        writer.println();
    }

    static private void makeAggregateTrack(String label, String vis, String url, String type, PrintWriter writer, int priority) {
        writer.printf("track %s\n", label);
        writer.printf("shortLabel %s\n", label);
        writer.printf("longLabel All optimal peaks (%s)\n", label);
        writer.printf("type %s\n", type);
        writer.println("color 0,0,0");
        writer.println("maxHeightPixels 128:40:15");
        writer.printf("visibility %s\n", vis);
        writer.println("autoScale on");
        writer.printf("bigDataUrl %s\n", url);
        writer.printf("priority %d\n", priority);

        writer.println();
    }

    // a supertrack for each tf
    static private void makeSuperTrack(String tfToShow, TreeNode tfNode, PrintWriter writer, File hubdir) throws Exception {
        Greek greek = new Greek();
        TF tf = (TF) tfNode.getData();
        boolean show = false;
        if (tfToShow != null) {
            show = tf.getId().equals(tfToShow);
        }
        String tfid = greek.translate(tf.getId());
        writer.printf("track %s\n", tfid);
        if (show) {
            writer.println("superTrack on show");
        } else {
            writer.println("superTrack on");
        }
        writer.printf("shortLabel %s\n", tfid);
        writer.printf("longLabel %s\n", tfid);
        writer.printf("html http://waterston.gs.washington.edu/modERN/html/tf/%s.html\n", tf.getId());
        writer.println();

        // build a composite track for each stage
        for (TreeNode stageNode : tfNode.getChildren()) {
            int nFiles = countHubFiles(stageNode);
            if (nFiles > 0) {
                makeCompositeTrack(tfid, tfid, stageNode, writer, hubdir);
            }
        }
    }

    // composite track for each experiment
    static private void makeCompositeTrack(String tf, String parent, TreeNode stageNode, PrintWriter writer, File hubdir) throws Exception {
        LifeStage stage = (LifeStage) stageNode.getData();
        TrackHub.formExpHtml(stage, hubdir);
        String trackId = stage.getAccession();
        writer.printf("   track %s\n", trackId);
        writer.println("   compositeTrack on");
        writer.printf("   parent %s\n", parent);
        writer.printf("   shortLabel %s\n", stage.getId());
        String longLabel = String.format("%s %s", tf, stage.getId());
        writer.printf("   longLabel %s\n", longLabel);
        writer.println("   visibility full");
        writer.printf("   html http://waterston.gs.washington.edu/modERN/html/exp/%s.html\n", trackId);

        TreeSet<String> replicates = new TreeSet<>();
        findReplicates(stageNode, replicates);

        // group the composite into views
        writer.print("   subGroup1 view Views ");
        for (TreeNode analysisNode : stageNode.getChildren()) {
            int nFiles = countHubFiles(analysisNode);
            if (nFiles > 0) {
                FileType fileType = (FileType) analysisNode.getData();
                String label = fileType.getId();
                String tag = FileType.trackHubMap.get(label);
                if (FileType.fileTypesInHubMap.get(tag) != null) {

                    label = label.replaceAll(" ", "_");
                    writer.printf("%s=%s ", tag, label);
                }
            }
        }
        writer.println();

        // subgroup for data source (experimental vs control)
        //       writer.println("   subGroup2 source Source IP=IP Control=Control");
        writer.print("   subGroup2 replicate Replicate ");
        for (String rep : replicates) {
            writer.printf("%s=%s ", rep, rep);
        }
        writer.println();
        writer.println("   dimensions dimX=replicate");
        writer.println("   sortOrder view=+ replicate=+");
        writer.println("   type bed 3");
        writer.println();

        // add the view stanzas
        for (TreeNode analysisNode : stageNode.getChildren()) {
            int nFiles = countHubFiles(analysisNode);
            if (nFiles > 0) {
                FileType fileType = (FileType) analysisNode.getData();
                String label = fileType.getId();
                String tag = FileType.trackHubMap.get(label);
                if (FileType.fileTypesInHubMap.get(tag) != null) {
                    makeViewTrack(trackId, tf, stage.getId(), tag, analysisNode, writer, hubdir);
                }
            }
        }

    }

    // a view track  for each type of data analysis
    static private void makeViewTrack(String parent, String tf, String stage, String typeTag, TreeNode analysisNode, PrintWriter writer, File hubdir) throws Exception {
        String trackId = String.format("%s_%s", typeTag, parent);
        TrackHub.formFileTypeHtml(hubdir);
        writer.printf("      track %s\n", trackId);
        writer.printf("      parent %s\n", parent);
        writer.printf("      shortLabel %s\n", typeTag);
        String longLabel = String.format("%s %s %s", tf, stage, typeTag);
        writer.printf("      longLabel %s\n", longLabel);
        writer.printf("      view %s\n", typeTag);
        List<TreeNode> fileNodes = analysisNode.getChildren();
        writer.printf("      type %s\n", FileType.fileTypesInHubMap.get(typeTag));
        String vis = "hide";
        if (typeTag.equals("Optimal")) {
            vis = "dense";
        }
        writer.printf("      visibility %s\n", vis);
        writer.printf("      html http://waterston.gs.washington.edu/modERN/html/file/filetype.html\n");
        writer.println();

        for (TreeNode fileNode : fileNodes) {
            makeFileTrack(trackId, tf, stage, typeTag, fileNode, writer, hubdir);
        }
    }

    // a track for each file
    static private void makeFileTrack(String parent, String tf, String stage, String typeTag, TreeNode fileNode, PrintWriter writer, File hubdir) throws Exception {
        String acc = null;
        ExperimentalFile expFile = (ExperimentalFile) fileNode.getData();
        TrackHub.formFileHtml(expFile, hubdir);
        if (fileNode.getData() instanceof ControlFile) {
            acc = ((ControlFile) fileNode.getData()).getInputAccession();
        } else {
            acc = expFile.getAccession();
        }
        String fileName = expFile.getId();
        String rep = replicate(fileName);
        String type = null;
        if (fileName.endsWith(".bw")) {
            type = "bigWig 0 1000";
        } else if (fileName.endsWith("bb")) {
            type = "bigBed 6 +";
        } else {
            return;
        }
        String vis = "hide";
        if (rep.equals("Combined")) {
            if (type.equals("bigWig")) {
                vis = "full";
            } else {
                vis = "dense";
            }
        }

        writer.printf("         track %s\n", acc);
        writer.printf("         parent %s\n", parent);
        writer.printf("         subGroups replicate=%s view=%s\n", rep, typeTag);
        writer.printf("         shortLabel %s\n", String.format("%s_%s", tf, stage));
        writer.printf("         longLabel %s %s %s %s\n", rep, typeTag, tf, stage);
        writer.printf("         type %s\n", type);
        writer.println("         color 0,0,0");
        writer.println("         maxHeightPixels 128:40:15");

        writer.printf("         visibility %s\n", vis);
        writer.println("         autoScale on");
        writer.printf("         bigDataUrl %s?proxy=true\n", expFile.getDownloadLink());
        writer.printf("         html http://waterston.gs.washington.edu/modERN/html/file/%s.html\n", acc);

        writer.println();
    }

    // count the number of files that will be displayed in the track hub under a given node
    public static int countHubFiles(TreeNode node) {
        int count = 0;
        if (node.getData() instanceof ExperimentalFile) {
            ExperimentalFile expFile = (ExperimentalFile) node.getData();
            String filename = expFile.getId();
            if (filename.endsWith("bw") || filename.endsWith("bb")) {
                count = 1;
            }
        } else {
            for (TreeNode child : node.getChildren()) {
                count = count + countHubFiles(child);
            }
        }
        return count;
    }

    // determine the number of replicates under a given node
    static public void findReplicates(TreeNode node, TreeSet<String> replicates) {
        if (node.getData() instanceof ExperimentalFile) {
            ExperimentalFile expFile = (ExperimentalFile) node.getData();
            replicates.add(replicate(expFile.getId()));
        } else {
            for (TreeNode child : node.getChildren()) {
                findReplicates(child, replicates);
            }
        }
    }

    // parse the replicate id from the fileName
    static public String replicate(String filename) {
        Matcher matcher = pattern1.matcher(filename);
        while (matcher.find()) {
            String rep = matcher.group();
            if (!rep.equalsIgnoreCase("Rep0")) {
                return matcher.group();
            }
        }
        matcher = pattern2.matcher(filename);
        if (matcher.find()) {
            return "Combined";
        } else {
            return "Control";
        }
    }

    static public void main(String[] args) throws Exception {
    }
    static Pattern pattern1 = Pattern.compile("(Rep\\d)");
    static Pattern pattern2 = Pattern.compile("tagAlign");
}
