/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.UCSC;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.util.Map.Entry;
import java.util.TreeMap;
import java.util.concurrent.RecursiveAction;

/**
 *
 * @author gevirl
 */
public class DownloadFiles extends RecursiveAction {
    TreeMap<String,URL> urlMap;
    public DownloadFiles(TreeMap<String,URL> urlMap){
        this.urlMap = urlMap;
    }

    @Override
    protected void compute() {
        if (urlMap.size() > thresh){
            // divide the problem in half
            TreeMap<String,URL> lower = new TreeMap<>();
            for (int i=0 ; i<urlMap.size()/2 ; ++i){
                Entry<String,URL> entry = urlMap.pollFirstEntry();
                lower.put(entry.getKey(), entry.getValue());
            }
            RecursiveAction.invokeAll(new DownloadFiles(lower), new DownloadFiles(urlMap));
            
        } else {
             // do the task
            byte[] data = new byte[BUFFER];
            for (String name : urlMap.keySet()){
                URL url = urlMap.get(name);
                try {
                    BufferedInputStream inStream = new BufferedInputStream(url.openStream());
                    int n;
                    n=inStream.read(data, 0, BUFFER);
                    File dest = new File(dir.getPath(),name);
                    Process p = Runtime.getRuntime().exec(String.format("mkdir -p %s",dest.getParent()));
                    p.waitFor();
                    PrintStream outStream = new PrintStream(dest);
                    outStream.write(data, 0, n);
                    while (n !=-1){
                        n=inStream.read(data, 0, BUFFER);
                        if (n > 0) outStream.write(data, 0, n);
                    }
                    inStream.close();   
                    outStream.close();
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
           
        }
    }
    static File dir = new File("/nfs/waterston");
    static final int thresh = 200;
    static final int BUFFER = 2048; 
}
