/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.UCSC;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import org.primefaces.model.TreeNode;
import org.rhwlab.encode.ChipSeq.ReleasedWormSelection;
import org.rhwlab.encode.ChipSeq.ViewByTF;
import org.rhwlab.modern.ExperimentalFile;
import org.rhwlab.modern.FileType;
import org.rhwlab.modern.LifeStage;
import org.rhwlab.modern.RecordBase;
import org.rhwlab.modern.ReferenceGenome;
import org.rhwlab.modern.TF;
import org.rhwlab.chipseq.ChipSeqBedRecord;

/**
 *
 * @author gevirl
 */
// aggregate ChipSeq peaks from multiple experiments (TFs/stages) into a single bed file
public class AggregateBed {

    ArrayList<ChipSeqBedRecord> bedRecords;

    public AggregateBed(TreeNode root, String fileType, String fileExt, Set<String> stages) throws Exception {
        bedRecords = new ArrayList<>();
        addFiles((RecordBase) root, fileType, fileExt, stages);
    }

    public AggregateBed(TreeNode root, String fileType, String fileExt) throws Exception {
        this(root, fileType, fileExt, null);
    }

    // gets the list of BedRecords for each tf
    public TreeMap<String, List<ChipSeqBedRecord>> getBedRecords() {
        TreeMap<String, List<ChipSeqBedRecord>> ret = new TreeMap<>();
        for (ChipSeqBedRecord rec : bedRecords) {
            String tf = rec.getTF();
            List<ChipSeqBedRecord> bedRecs = ret.get(tf);
            if (bedRecs == null) {
                bedRecs = new ArrayList<>();
                ret.put(tf, bedRecs);
            }
            bedRecs.add(rec);
        }
        return ret;
    }

    public void writeTo(File file) throws Exception {

        PrintStream stream = new PrintStream(file);
        for (ChipSeqBedRecord rec : bedRecords) {
            stream.println(rec.toString());
        }
        stream.close();
        Runtime.getRuntime().exec(String.format("chmod 666 %s", file.getPath()));

    }
/*
    public void writeAnnotatedBedTo(File file) throws Exception {

        PrintStream stream = new PrintStream(file);
        for (ChipSeqBedRecord rec : bedRecords) {
            stream.println(rec.toString());
        }
        stream.close();
        Runtime.getRuntime().exec(String.format("chmod 666 %s", file.getPath()));
    }
*/
    // convert the coordinates to a single base at the peak
    public void writePointBedTo(File file) throws Exception {
        TreeSet<ChipSeqBedRecord> recs = new TreeSet<>();
        PrintStream stream = new PrintStream(file);
        for (ChipSeqBedRecord rec : bedRecords) {
            recs.add(rec.toPointCoordinates());
        }
        for (ChipSeqBedRecord rec : recs) {
            stream.println(rec.toString());
        }
        stream.close();
        Runtime.getRuntime().exec(String.format("chmod 666 %s", file.getPath()));
    }

    final private void addFiles(RecordBase node, String filePrefix, String fileExt, Set<String> stageSet) throws Exception {
        if (node instanceof FileType) {
            FileType typeNode = (FileType) node;
//            if (typeNode.getId().equals(fileType)){
            LifeStage stageNode = (LifeStage) node.getParent();
            TF tfNode = (TF) stageNode.getParent();
            for (TreeNode child : node.getChildren()) {
                ExperimentalFile fileNode = (ExperimentalFile) child;
                if (fileNode.getId().endsWith(fileExt) && fileNode.getId().startsWith(filePrefix)) {
                    // get the tf from the filename
                    String fileName = fileNode.getId();
 //                   String first = fileName.split("_")[0];
 //                   String tf = first.substring(filePrefix.length() + 1);
                    System.out.println(fileName);
                    URL url = new URL(fileNode.getDownloadLink());
//                    readBedRecords(tfNode.getId().toUpperCase(), stageNode.getId(), url, bedRecords);
                    readBedRecords(tfNode.getId(), stageNode.getId(), url, bedRecords);
                }
            }
//            }
        } else if (node instanceof LifeStage && stageSet != null) {
            LifeStage lifeStage = (LifeStage) node;
            String stage = lifeStage.getId();
            stage = stage.replaceAll(" ", "");
            stage = stage.replace('/', '_');
            if (stageSet.contains(stage)) {
                for (TreeNode child : node.getChildren()) {
                    addFiles((RecordBase) child, filePrefix, fileExt, stageSet);
                }
            }
        } else {
            for (TreeNode child : node.getChildren()) {
                addFiles((RecordBase) child, filePrefix, fileExt, stageSet);
            }
        }
    }

    static public void readBedRecords(String tf, String stage, URL url, ArrayList<ChipSeqBedRecord> bedRecords) throws Exception {
        InputStream urlInput = url.openStream();
        GZIPInputStream gzip = new GZIPInputStream(urlInput);
        BufferedReader reader = new BufferedReader(new InputStreamReader(gzip));
        String line = reader.readLine();
        while (line != null) {
            ChipSeqBedRecord rec = new ChipSeqBedRecord(line);
            rec.setName(String.format("%s_%s", tf, stage).replaceAll(" ", "_"));
            bedRecords.add(rec);
            line = reader.readLine();
        }
        reader.close();
    }

    static public void main(String[] args) throws Exception {
        ReleasedWormSelection worm = new ReleasedWormSelection(new java.io.File("/net/waterston/vol2/home/gevirl", "ReleasedWormChipSeqExperiments"));
//        worm.saveToDirectory(new java.io.File("/net/waterston/vol2/home/gevirl", "ReleasedWormChipSeqExperiments"));
        //       worm.indexDirectory();   

        ReferenceGenome genome = new ReferenceGenome();
        ViewByTF view = new ViewByTF();
        view.setGenomes(genome);
        view.setSpecies("worm");
        view.setSelection(worm);
        genome.setAssembly("worm", "ce11");
        AggregateBed aggBed = new AggregateBed(view.getRoot(), "spp.optimal", "gz");
    }
}
