/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet.config;

import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.jdom2.Element;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.Filter;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.SpreadSheetPanel;

/**
 *
 * @author gevirl
 */
public class SpreadSheet {
    public SpreadSheet(String title){
        this.title = title;
    }
    public SpreadSheet(Element ssElement) throws Exception {
 
        title = ssElement.getAttributeValue("title");
        dbTable = ssElement.getAttributeValue("dbtable");
        
        // find the primary keys for the backing db table
        if (dbTable != null) {
            String sql = String.format("select table_name,column_name from information_schema.columns where table_name=\'%s\' and column_key=\'PRI\'", dbTable);
            ResultSet rs = MySql.getMySql().execute(sql);
            while (rs.next()) {
                String tbl = rs.getString("table_name");
                if (tbl.equals(dbTable)){
                    keys.add(rs.getString("column_name"));
                }
            }
        }        
        project = ssElement.getAttributeValue("project");
        
        String modelStr = ssElement.getAttributeValue("model");
        sheetModel = Class.forName(modelStr);
        
        String panelStr = ssElement.getAttributeValue("panel");
        sheetPanel = Class.forName(panelStr);        

        List<Element> children = ssElement.getChildren("Transfer");
        for (Element child : children){
            transfers.add(new Transfer(child));
        }
        
        children = ssElement.getChildren("Column");
        for (Element child : children){
            addColumn(new Column(this,child));
        }
        
        children = ssElement.getChildren("Json");
        for (Element child : children){
            jsons.add(new JsonConfig(this,child));
        }
        
        children = ssElement.getChildren("Mapped");
        for (Element child : children){
         String mappedClass  = child.getAttributeValue("class"); 
         String repeat = child.getAttributeValue("repeat");
         repeats.put(mappedClass, new Integer(repeat));
        }  
        
        children = ssElement.getChildren("Cell");
        for (Element child : children){
            cells.add(new Cell(child));
        }
        
        children = ssElement.getChildren("GridSubmit");
        for (Element child : children){
            gridSubmits.add(new GridSubmission(child));
        }
    }
    final public void addColumn(Column column){
        columns.add(column);
    }
    public int getColumnCount(){
        return columns.size();
    }
    public Column getColumn(int i){
        
        return columns.get(i);
    }
    public int getColumn(String head){
        for (int i=0 ; i<columns.size() ; ++i){
            Column col = columns.get(i);
            if (col.getHeader().equals(head)){
                return i;
            }
        }
//        System.out.printf("Unknow column: %s\n", head);
        return -1;
    }
    // find the model column that coresponds to a database column by name
    public int getDbColumn(String name){
        for (int i=0 ; i<columns.size() ; ++i){
            Column col = columns.get(i);
            if (col.getDbColumn()==null)continue;
            if (col.getDbColumn().equals(name)){
                return i;
            }
        }
        return -1;
    }    
    public String getDbTable(){
        return this.dbTable;
    }
    public SpreadSheetModel newModel()throws Exception {
        return (SpreadSheetModel)sheetModel.newInstance();
    }
    public SpreadSheetPanel newPanel()throws Exception {
        SpreadSheetPanel panel =  (SpreadSheetPanel)sheetPanel.newInstance();
        allPanels.add(panel);
        return panel;
    } 
    public String getTitle(){
        return title;
    }
    public SpreadSheetPanel getPanel(String panelClassName){
        for (SpreadSheetPanel panel : allPanels){
            if (panel.getClass().getName().equals(panelClassName)){  
                return panel;
            }
        }
        return null;
    }
    public ArrayList<String>[] getMappedColumns(String panelClassName){
        ArrayList<ArrayList<String>> ret = new ArrayList<ArrayList<String>>();
        for (Column col: columns){
            int n = col.getMapCount();
            if (n == 0 ) continue;
            while (ret.size()< n){
                ArrayList<String> list = new ArrayList<String>();
                ret.add(list);
            }
            
            String name = col.getMapToColumn(panelClassName);
            if (name != null){
                for (int i=0 ; i<n ; ++i){
                    ArrayList list = ret.get(i);
                    list.add(name);
                }
            }
        }
        return ret.toArray(new ArrayList[0]);
    }
    public int mappedTo(String panelClassName,String colName){
        for (int i=0 ; i<columns.size() ; ++i){
            Column col = columns.get(i);
            String name = col.getMapToColumn(panelClassName);
            if (name!=null && name.equals(colName)){
                return i;
            }
        }
        return -1;
    }

    public String[] getTransfers(){
        String[] ret = new String[transfers.size()];
        for (int i=0 ; i<ret.length ; ++i){
            ret[i] = transfers.get(i).getName();
        }
        return ret;
    }
    public Transfer getTransfer(String transferName){
        for (Transfer transfer : transfers){
            if (transferName.equals(transfer.getName())){
                return transfer;
            }
        }
        return null;
    }
    public int getRepeat(String panelClass){
        Integer ret = repeats.get(panelClass);
        if (ret == null){
            return 1;
        }else {
            return ret.intValue();
        }
    }
    public String getProject(){
        return project;
    }
    public Cell[] getCells(){
        return cells.toArray(new Cell[0]);
    }
    public ArrayList<String> getPrimaryKeys(){
        return keys;
    }
    public List<JsonConfig> getJsons(){
        return this.jsons;
    }
    public JsonConfig getJsonConfig(String schemaName){
        for (JsonConfig json : jsons){
            if (schemaName.equals(json.getSchemaName())){
                return json;
            }
        }
        return null;
    }
    public TreeSet<String> getSortedColumnHeaders(){
        // make a sorted set of column names
        TreeSet<String> columnNames = new TreeSet<>();
        for (Column column : columns){
            columnNames.add(column.getHeader());
        }
        return columnNames;
        
    }
    public Filter[] getFilter(){
        ArrayList<Filter> ret = new ArrayList<>();
        for (Column c : columns){
            Filter[] filters = c.getFilter();
            for (Filter f : filters){
                ret.add(f);
            }
        }
        if (ret.isEmpty()) return new Filter[0];
        return ret.toArray(new Filter[0]);
    }
    
    public List<GridSubmission> getGridSubmits(){
        return gridSubmits;
    }

    String title;
    String dbTable;
    String project;
    List<Column> columns = new ArrayList<Column>();
    ArrayList<String> keys = new ArrayList<String>();
    List<Transfer> transfers = new ArrayList<Transfer>();
    List<Cell> cells = new ArrayList<Cell>();
    List<JsonConfig> jsons = new ArrayList<JsonConfig>();
    HashMap<String,Integer> repeats = new HashMap<String,Integer>();
    List<GridSubmission> gridSubmits = new ArrayList<>();
    Class sheetModel;
    Class sheetPanel;
    public static ArrayList<SpreadSheetPanel> allPanels = new ArrayList<SpreadSheetPanel>();
}
