/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.rhwlab.encode.CollectionUrl;
import org.rhwlab.encode.DataItemUrl;
import org.rhwlab.encode.EncodeSchemaUrl;
import org.rhwlab.encode.EncodeUrl;

/**
 *
 * @author gevirl
 */
public class JsonConfig {
    public JsonConfig(SpreadSheet sheet,Element jsonEle)throws Exception {
        this.sheet = sheet;
        List<Attribute> attributes = jsonEle.getAttributes();
        for (Attribute attribute : attributes){
            if (attribute.getName().equals("schema")){
                schemaName = attribute.getValue();
            }
            else if (attribute.getName().equals("collection")){
                collection = attribute.getValue();
            }
            else if (attribute.getName().equals("server")){
                server = attribute.getValue();
            } 
            else {
                criteria.put(attribute.getName(), attribute.getValue());
            }           
        }
        EncodeUrl url = new EncodeSchemaUrl(schemaName);
        url.getJson();
        schema = url.getJsonObject();
        collectionUrl = new CollectionUrl(server,collection);
        
        mappingList = new ArrayList<>();
        List<Element> mapEles = jsonEle.getChildren("Mapping");
        for (Element mapEle : mapEles){
            mappingList.add(new Mapping(mapEle));
        }
    }
    public JsonObject getFromDCCbyAlias(JsonObject obj)throws Exception {
        String alias = obj.getJsonArray("aliases").getJsonString(0).getString();
        return getFromDCC(alias);
    }
    // gets the meta data object from the DCC collection by alias
    public JsonObject getFromDCC(String alias)throws Exception {
        dataUrl = new DataItemUrl(server,collection,alias);
        dataUrl.getJson();
        return dataUrl.getJsonObject();
    }
    public static JsonObject getFromDCC(String server,String collection,String alias)throws Exception {
        DataItemUrl dataUrl = new DataItemUrl(server,collection,alias);
        dataUrl.getJson();
        return dataUrl.getJsonObject();        
    }
    // return null if error submitting
    // this submits metadata only to DCC
    // submitting data files is done elsewhere - see AWS class
    public String submitJson(Map<String,String> data)throws Exception {
        JsonObject jsonObj = buildJson(data);
        
        // has the alias already been submitted
        getFromDCCbyAlias(jsonObj);  // this uses the dataUrl and goes a GET
        
        boolean responseError = false;
        if (dataUrl.isError()){
            // object not in DCC - POST it
            response= collectionUrl.postJson(jsonObj);
            responseError = collectionUrl.isError();
        } else {
            // object already in DCC - PATCH it
            response =  dataUrl.patchJson(jsonObj);
            responseError = dataUrl.isError();
        }
        
        // check response for error
        if (responseError){
            return null;
        }
        return response;
    }
    public String postJson(Map<String,String> data)throws Exception {
        JsonObject jsonObj = buildJson(data);
        response= collectionUrl.postJson(jsonObj);
        if (collectionUrl.isError()){
            return null;
        }
        return response;
    }
    public String patchJson(Map<String,String> data,String acc)throws Exception {
        JsonObject jsonObj = buildJson(data);
        dataUrl = new DataItemUrl(server,collection,acc);
        response =  dataUrl.patchJson(jsonObj);
        if (dataUrl.isError()){
            return null;
        }
        return response;
    }    
    public JsonObject buildJson(Map<String,String> data){
        JsonObjectBuilder builder = Json.createObjectBuilder();
        JsonObject propertiesObject = schema.getJsonObject("properties");
        for (Mapping mapping:mappingList){
            String prp = mapping.property;
            JsonObject propertyObject = propertiesObject.getJsonObject(prp);
            if (propertyObject == null){
                int aisfhsa=0;
            }
            String propertyType = propertyObject.getString("type");
            if (propertyType.equalsIgnoreCase("string")){
                String[] vs = mapping.dataValue(data);
                if (vs.length>0){
                    String v = vs[0];
                    if (!v.equals("")) builder.add(mapping.property, v);  // only add non blank data to the json
                }
            } else if (propertyType.equalsIgnoreCase("array")){
                String[] vals = mapping.dataValue(data);
                boolean canSubmit = false;
                for (String val : vals){
                    if (!val.equals("")){
                        canSubmit = true;
                        break;
                    }
                }
                if (canSubmit){
                    JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
                    for (String val : vals){
                        arrayBuilder.add(val);
                    }
                    builder.add(mapping.property,arrayBuilder);
                }
            } else if (propertyType.equalsIgnoreCase("integer")){
                String[] vs = mapping.dataValue(data);
                if (vs.length>0){
                    String v = vs[0];
                 if (!v.equals("")) builder.add(mapping.property,Integer.valueOf(v));  // only add non blank data to the json  
                }
            } else if (propertyType.equalsIgnoreCase("boolean")){
                String[] vs = mapping.dataValue(data);
                if (vs.length>0){
                    String v = vs[0];
                    if (v.equals("true")){
                        builder.add(mapping.property,true);
                    } else {
                        builder.add(mapping.property,false);
                    }
                }
            }
            int askdf=0;
        }
    return builder.build();
    }
    
    public Set<String> getColumnHeaders(){
        TreeSet<String> ret = new TreeSet<>();
        for (Mapping mapping : mappingList){
            Set<String> mappingHeads = mapping.getHeaders();
            ret.addAll(mappingHeads);
        }
        return ret;
    }
    
    public EncodeUrl getUrl(){
        return this.collectionUrl;
    }
    public String getResponse(){
        return this.response;
    }
    public String getSchemaName(){
        return this.schemaName;
    }

    public String getServer(){
        return server;
    }
    public TreeMap<String,String> getCriteria(){
        return this.criteria;
    }
    public boolean isError(){
        return dataUrl.isError();
    }
    TreeMap<String,String> criteria = new TreeMap<>();
    String server ;
    String schemaName;
    SpreadSheet sheet;
    JsonObject schema;
    String collection;
    CollectionUrl collectionUrl;
    DataItemUrl dataUrl;
    List<Mapping> mappingList;
    String response;
    

}
