/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet.config;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdom2.Element;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.Filter;

/**
 *
 * @author gevirl
 */
public class Column {
    
    public Column(String header,Class type,Class editor){
        this.header = header;
        this.dataType = type;
        this.editor = editor;
    }
    
    public Column(SpreadSheet sheet,Element colElement) throws Exception{
        this.sheet = sheet;
        header = colElement.getAttributeValue("header");
        this.dbColumn = colElement.getAttributeValue("dbcolumn");
        if (colElement.getAttributeValue("key") != null){
            key = true;
        }
        String className = colElement.getAttributeValue("class");
        if (className != null){
            dataType = Class.forName(className);
        }
        String editorName = colElement.getAttributeValue("editor");
        if (editorName != null){
            editor = Class.forName(editorName);
        }
        String compareName = colElement.getAttributeValue("compare");
        if (compareName != null){
            compare = Class.forName(compareName);
        }        
        defaultValue = colElement.getAttributeValue("default");
        
        select = colElement.getAttributeValue("select");
        selectColumn = colElement.getAttributeValue("selectColumn");
        
        String rendererName = colElement.getAttributeValue("renderer");
        if (rendererName != null){
            renderer = Class.forName(rendererName);
        }        
        List<Element> children = colElement.getChildren("Listener");
        for (Element child : children){
            String colListener = child.getAttributeValue("column");
            if (colListener != null){
                listeners.add(colListener);
            }
            String panelListener = child.getAttributeValue("panel");
            if (panelListener != null){
                panelClasses.add(panelListener);
            }            
        }
        List<Element> params = colElement.getChildren("Parameter");
        for (Element param : params){
            String name = param.getAttributeValue("name");
            String value = param.getAttributeValue("value");
            parameters.put(name, value);
        }   
        List<Element> mapTos = colElement.getChildren("MapTo");
        for (Element mapTo : mapTos){
            String panel = mapTo.getAttributeValue("panel");
            String col = mapTo.getAttributeValue("column");
            
            String mapping = mapTo.getAttributeValue("mapping");
            if (mapping==null) mapping = "default";
            
            HashMap<String,String> hash=mappedTo.get(mapping);
            if (hash == null) {
                hash = new HashMap<String,String>();
                mappedTo.put(mapping,hash);
            } 
            hash.put(panel,col);
            
            if (mapTo.getAttribute("noNotify")!=null){
                this.notifyOnMapping = false;
            }

        }
        
        this.invisible = colElement.getAttributeValue("invisible")!=null;
        this.notifyOnLoading = colElement.getAttributeValue("NotifyOnLoad")!=null;
        this.updateAfterLoad = colElement.getAttributeValue("UpdateAfterLoad")!=null;
        
        children = colElement.getChildren("Filter");
        for (Element filter : children){    
            CellBase lowValue = (CellBase)this.newObject();
            lowValue.setValue(filter.getAttributeValue("low"), false);
            CellBase highValue = (CellBase)this.newObject();
            highValue.setValue(filter.getAttributeValue("high"), false);
            columnFilter.add(new Filter(header,lowValue,highValue));        
        }    
        String wString = colElement.getAttributeValue("width");
        if (wString != null){
            this.preferedWidth = Integer.valueOf(wString);
        }
        
    }
    public String getHeader(){
        return header;
    }
    // make a table with one cell 
    public JTable singleCellTable()throws Exception {
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn(header);
        JTable ret = new JTable(model);
        JTableHeader tableHeader = ret.getTableHeader();
        tableHeader.setVisible(false);
        model.setRowCount(1);
        CellBase base = (CellBase)this.newObject();
        base.setValidate(false);
        model.setValueAt(base, 0, 0);
        TableCellEditor celleditor = this.newEditor();
        if (celleditor == null){
            celleditor = (TableCellEditor)Class.forName("org.rhwlab.spreadsheet.TextEditor").newInstance();
        }
        TableColumnModel colModel = ret.getColumnModel();
        TableColumn tableColumn = colModel.getColumn(0);
        tableColumn.setCellEditor(celleditor);        
        
        return ret;
    }

    public Object newObject() throws Exception {
        if (dataType != null)
            try {
            return dataType.newInstance();
            } catch (Exception exc){
                int asjkdfh=0;
                
            }
        return null;
    }
    public TableCellEditor newEditor() throws Exception {
        if (editor != null){
            return (TableCellEditor)editor.newInstance();
        }
        return null;
    }
    public TableCellRenderer newRenderer() throws Exception {
        if (renderer != null){
            return (TableCellRenderer)renderer.newInstance();
        }
        return null;
    } 
    public Comparator newCompare() throws Exception {
        if (compare != null){
            return (Comparator)compare.newInstance();
        }
        return null;
    }
    public String[] getListeningColumns(){
        return listeners.toArray(new String[0]);
    }
    public String[] getListeningPanels(){
        return panelClasses.toArray(new String[0]);
    }    
    public String getDbColumn(){
        return this.dbColumn;
    }

    // the column is editable if it has an editor class designated
    public boolean isEditable(){
        return editor!=null;
    }
    public String getParameterValue(String name){
        return parameters.get(name);
    }
    public String[] getParameterNames(){
        return parameters.keySet().toArray(new String[0]);
    }
    // returns the column in the destination panel that is mapped to this column
    // given the class of the destination panel
    public String getMapToColumn(String panel){
        return getMapToColumn(panel,"default");
    }
    public String getMapToColumn(String panel,String m){
        return this.mappedTo.get(m).get(panel);
    }
    public int getMapCount(){
        return mappedTo.size();
    }
    /*
    public String[] getMapToPanels(){
        return this.mappedTo.get(0).keySet().toArray(new String[0]);
    } 
*/
    public boolean isKey(){
        return key;
    }
    public String getDefault(){
        return this.defaultValue;
    }
    public String getSelect(){
        return this.select;
    }
    public boolean notifyOnMapping(){
        return this.notifyOnMapping;
    }
    public boolean notifyOnLoading(){
        return this.notifyOnLoading;
    }
    public Class getDataClass(){
        return dataType;
    }
    public boolean isSelectColumn(){
        return select!=null;
    }
    public String getSelectColumn(){
        return selectColumn;
    }
    
    // find the columns that notify this column of changes
    public List<Column> getNotifiers(){
        ArrayList<Column> ret = new ArrayList<>();
        int n = sheet.getColumnCount();
        for (int i=0 ; i<n ; ++i){
            Column col = sheet.getColumn(i);
            if (!this.header.equals(col.header)){  // don't process this column
                for (String listener : col.listeners){
                    if (listener.equals(this.header)){
                        ret.add(col);
                        break;
                    }
                }
            }
        }
        return ret;
    }
    public boolean isVisible(){
        return !invisible;
    }
    public int getColumn(){
        return sheet.getColumn(header);
    }
    public Filter[] getFilter(){
        return this.columnFilter.toArray(new Filter[0]);
    }
    public boolean isUpdateAfterLoad(){
        return this.updateAfterLoad;
    }
    public Integer getPreferredWidth(){
        return this.preferedWidth;
    }
    ArrayList<Filter> columnFilter = new ArrayList<>();
    boolean invisible = false;
    SpreadSheet sheet;
    String select = null;
    String selectColumn=null;
    String defaultValue;
    boolean key = false;
    String header;
    String dbColumn=null;
    Class dataType;
    Class editor;
    Class renderer;
    Class compare;
    HashMap<String,HashMap<String,String>> mappedTo = new HashMap<String,HashMap<String,String>>();  // <Mapping id>,<Panel Class><column header>
    boolean notifyOnMapping = true;
    boolean notifyOnLoading = false;
    boolean updateAfterLoad = false;
    Integer preferedWidth=null;
    ArrayList<String> listeners = new ArrayList<String>();  // list of columns that listen to this column
    ArrayList<String> panelClasses = new ArrayList<String>();  // list of panel classes that listen to this column 
    HashMap<String,String> parameters = new HashMap<String,String>();
}
