/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet.config;

import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;

/**
 *
 * @author gevirl
 */
public class Cell {
    public Cell(Element colElement) throws Exception{
        label = colElement.getAttributeValue("label");
        String className = colElement.getAttributeValue("class");
        if (className != null){
            dataType = Class.forName(className);
        } 
        defaultValue = colElement.getAttributeValue("default");        
        List<Element> children = colElement.getChildren("Listener");
        for (Element child : children){
            String colListener = child.getAttributeValue("column");
            if (colListener != null){
                listeners.add(colListener);
            }
        }        
    }
    public Object newObject() throws Exception {
        if (dataType != null)
            return dataType.newInstance();
        return null;
    }
    public String getDefaultValue(){
        return this.defaultValue;
    }
    public String[] getListeningColumns(){
        return listeners.toArray(new String[0]);
    }
    public String getLabel(){
        return label;
    }
    String label;
    Class dataType;
    ArrayList<String> listeners = new ArrayList<String>();  // list of columns that listen to this cell  
    String defaultValue;
}
