/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.rhwlab.LMS.trace.PromoterTracerTree;
import org.rhwlab.LMS.trace.TracerTree;

/**
 *
 * @author gevirl
 */
public class TreeDisplay extends AbstractCellEditor implements TableCellEditor{
    public TreeDisplay(){
        button = new JButton();
        dialog = new JDialog();
        dialog.setSize(new Dimension(500,300));
        
        Container content = dialog.getContentPane();
        tree = new JTree();

        
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(tree);
        content.add(scroll);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
 //               dialog.setLocationRelativeTo(button);
                dialog.setVisible(true);
            }
        });        
    }
    public Object getCellEditorValue(){
        return cellObj;
    }
    
    public Component getTableCellEditorComponent(JTable table,Object value, boolean isSelected,int row, int column) {
        cellObj = (CellBase)value;
        TracerTree traceTree = (TracerTree)cellObj.getValue();
        button.setText(cellObj.getValueAsString());
        
        tree.setModel(new DefaultTreeModel(traceTree.getRoot()));
        expandNode(traceTree.getRoot());
        return button;
    }
    // expand the given node and all it's children
    public void expandNode(DefaultMutableTreeNode node) {
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        TreeNode[] nodepath = model.getPathToRoot(node);
        
        tree.expandPath(new TreePath(nodepath));
        
        int n = node.getChildCount();
        for (int i=0 ; i<n ; ++i){
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            this.expandNode(child);
        }
    }    
  
    JTree tree;
    JDialog dialog;
    CellBase cellObj;  
    JButton button;
}
