/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.rhwlab.LMS.dialogs.TrackingFilterDialog;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.config.Column;
import org.rhwlab.spreadsheet.config.SpreadSheet;

/**
 *
 * @author gevirl
 */
abstract public class TrackingPanel extends SpreadSheetPanel {
    public TrackingPanel(boolean addRows,String[] inits){
        super(addRows);
        buildMenu();
        dialog = new TrackingFilterDialog(inits);
    }
    public void setConfig(SpreadSheet con) throws Exception {
        super.setConfig(con);
        dialog.setConfig(con);
    }    
    @Override
    public void updateDB()throws Exception {
        // update all the tracking first
        boolean updated = updateTracking();
        
        this.model.updateDb();
        
        if (updated){
            String msg = String.format("There have been tracking changes for project: %s\nThere may be other projects to change",this.project.getValueAsString());
            JOptionPane.showMessageDialog(scrollPane, msg);
        }
    }
    public boolean updateTracking()throws Exception {
        boolean ret = false;
        int c = this.config.getColumn("Tracking");
        int[] rows = this.getModelRows();
        for (int r : rows){
            TrackItem trackcell = (TrackItem)this.model.getValueAt(r, c);
            if (trackcell.updateDB()){
                ret = true;
            }
        } 
        return ret;
    }
    public boolean hasTrackingChanged(){
        int c = this.config.getColumn("Tracking");
        int[] rows = this.getModelRows();
        for (int r : rows){
            TrackItem trackcell = (TrackItem)this.model.getValueAt(r, c);
            if (trackcell.hasChanged()){
                return true;
            }
        } 
        return false;
    }
    private void buildMenu(){
        menu = new JMenu();
        JMenuItem tracking = new JMenuItem("Tracking Filters");
        tracking.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                // bring up the tracking dialog
                dialog.setSize(900,250);
                dialog.setLocationRelativeTo(TrackingPanel.this);
                dialog.setVisible(true);
                
                if (dialog.isOK()){
                    try {
                        String whereClause = dialog.getWhereClause();
                        loadWithTracking(whereClause,dialog.getSelected());
                    } catch (Exception exc){
                        exc.printStackTrace();
                    }
                }
            }
        });
        menu.add(tracking);
    }
    public void loadModelFromDB()throws Exception {
        String[] tracks = dialog.getSelected();
        loadWithTracking("",tracks);
    }
    public void loadWithTracking(String dataTableWhere,String where,Filter[] filters)throws Exception{
        String key = this.config.getPrimaryKeys().get(0);
        String dbtable = this.config.getDbTable();
        String proj = this.getProject();
        
        // this sql query will get all records (all tracking status)
        String sql = null;
/*        
        sql = String.format(
                "select T.*,S.Status Tracking,S.Reason from %s T left join (select * from LMSTracking L where (L.DBTable=\'%s\' or L.DBTable is null) and (L.Project=\'%s\' or L.Project is null) ) S on T.%s=S.ID ",
           dbtable,dbtable,proj,key);            

        
        if (where != null){
            sql = sql + where;   
        }
*/        
        ResultSet rs=null;
        sql = String.format("create temporary table LMStmp as select * from LMSTracking L where (L.DBTable=\'%s\') and (L.Project=\'%s\')\n",dbtable,proj);
        MySql.getMySql().execute(sql);
        
        sql = "create index tmp_id on LMStmp(ID)\n";
        MySql.getMySql().execute(sql);
        
        if (!dataTableWhere.equals("")){
            try {
            sql = String.format("drop table %stmp",dbtable);
            MySql.getMySql().execute(sql);
            } catch(Exception exc){}
            
            sql = String.format("create temporary table %stmp as select * from %s where %s",dbtable,dbtable,dataTableWhere);
            MySql.getMySql().execute(sql);
            
            dbtable = dbtable + "tmp";
        }
        sql = String.format("select  T.*,S.Status Tracking,S.Reason  from %s T left join LMStmp S on T.%s=S.ID\n",dbtable,key);
        if (where != null){
            sql = sql + where;
        }
        rs = this.model.loadFromDb(sql, filters);
        sql = "drop table LMStmp\n";
        MySql.getMySql().execute(sql);
        if (rs == null) return;
        
        // set up the tracking cells
        int trackCol = this.config.getColumn("Tracking");
        List<Column> trackNotifiers = this.config.getColumn(trackCol).getNotifiers();
        for ( int r=0 ; r< this.model.getRowCount() ; ++r){
            String keyValue = this.getValue(r,trackNotifiers.get(0).getHeader());
            TrackItem trackCell = (TrackItem)this.model.getValueAt(r,trackCol);
            trackCell.setKeyValue(keyValue);
            trackCell.setProject(proj);            
        }
       
    }    
    public void loadWithTracking(String dataWhereClause)throws Exception {
        String whereClause = dialog.getWhereClause();
        loadWithTracking(dataWhereClause,whereClause,new Filter[0]);
    }
    public void loadWithTracking(String dataTableWhere,String[] trackValues)throws Exception{
        String where="";

        ResultSet rs=null;
        if (trackValues!= null && trackValues.length>0){
            
            // compose the where clause to filter on only the specified status's
            boolean first = true;
            StringBuilder builder = new StringBuilder(" where (");
            for (String trackValue : trackValues){
                if (!first) builder.append("or ");
                builder.append(String.format("S.Status = \'%s\' ", trackValue));
                first = false;
            }
            builder.append(")");
            where = builder.toString();
            
            loadWithTracking(dataTableWhere,where,this.config.getFilter());
           
        }else {
            loadWithTracking(dataTableWhere,null,new Filter[0]);
        }
        
        if (rs == null) return;
    }
    
    public JMenu getMenu() {
        if (menu == null) buildMenu();
        return menu;
    }
    
    TrackingFilterDialog dialog;
}
