/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet;

import java.awt.Component;
import java.awt.Toolkit;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

/**
 *
 * @author gevirl
 */
public class TextEditor extends DefaultCellEditor {
    public TextEditor(){
        super(new JTextField());
    }
    //Override to invoke setValue on the formatted text field.
    public Component getTableCellEditorComponent(JTable table,Object value, boolean isSelected,int row, int column) {
        cellObj = (CellBase)value;
        String cellString = cellObj.getValueAsString();
        JTextField textField = (JTextField)super.getTableCellEditorComponent(table, cellString, isSelected, row, column);
        return textField;
    } 
    
     public Object getCellEditorValue() {
       JTextField textField = (JTextField)getComponent();
       String text = textField.getText().trim();
       String oldText = cellObj.getValueAsString();
       if (!text.equals(oldText)){
            cellObj.setValue(text);
            cellObj.unlock();
       }
       return cellObj;
    }
     public boolean stopCellEditing() {
         JTextField textField = (JTextField)getComponent();
         String newValue = textField.getText().trim();
         String oldText = cellObj.getValueAsString();
         if (oldText.equals(newValue)) return super.stopCellEditing();
         if (cellObj.validate(newValue)){
             return super.stopCellEditing();

         } else {
             if (revert()){
                 textField.setText(cellObj.getValueAsString());
                 return false; // go back to editing
             }
         }
         return false;
     }
     private boolean revert(){
         JTextField textField = (JTextField)getComponent();
        Toolkit.getDefaultToolkit().beep();
        Object[] options = {"Edit",
                            "Revert"};
        int answer = JOptionPane.showOptionDialog(
            SwingUtilities.getWindowAncestor(textField),
            "You can either continue editing "
            + "or revert to the last valid value.",
            "Not a Valid Entry",
            JOptionPane.YES_NO_OPTION,
            JOptionPane.ERROR_MESSAGE,
            null,
            options,
            options[1]);
	    
        if (answer == 1) { //Revert!
	    return true;
        }
	return false;         
     }
     CellBase cellObj;
}
